package com.sonicsw.ma.gui.perms;

import java.util.ArrayList;
import java.util.List;

import com.sonicsw.ma.plugin.IPlugin;

public abstract class PermissionsList {

    protected List perms;
    protected IPlugin subject;  

    public PermissionsList(ArrayList perms, IPlugin subject) {
        this.subject = subject;
        this.perms = perms;
    }

    public List getPermissions() {
        return perms;
    }

    public void setPermissions(List perms) {
        this.perms = perms;
    }

    public abstract ScopeType[] getAvailableScopeTypes();

    public abstract PermissionType[] getAvailablePermissionTypes();

    public abstract AbstractPermissions newPermissions(AbstractPermissions.Principal principal);


    public static class ScopeType {
        private String displayName;
        private int bits;

        public ScopeType(String displayName,int bits) {
            this.displayName = displayName;
            this.bits = bits;
        }

        public String getDisplayName() {
            return displayName;
        }

        public int getBits() {
            return bits;
        }

        @Override
        public String toString() {
            return displayName;
        }
    }

    public static class PermissionType {
        public final String name;
        public final int    allowBit;
        public final int    denyBit;

        public PermissionType(String name, int allowBit, int denyBit) {
            this.name = name;
            this.allowBit = allowBit;
            this.denyBit = denyBit;
        }
    }



    public static class ConfigurePermissionsList extends PermissionsList {

        public ConfigurePermissionsList(IPlugin subject) {
            this(new ArrayList(),subject);
        }

        public ConfigurePermissionsList(ArrayList perms, IPlugin subject) {
            super(perms, subject);
        }

        @Override
        public ScopeType[] getAvailableScopeTypes() {
            if(ManagementSecurityUtils.isFolder(subject))
            {
                return ConfigurePermissions.folderScopeTypes;
            }
            return ConfigurePermissions.fileOrConfigScopeTypes;
        }

        @Override
        public PermissionType[] getAvailablePermissionTypes() {
            return ConfigurePermissions.permissionTypes;
        }

        @Override
        public AbstractPermissions newPermissions(AbstractPermissions.Principal principal) {
            return new ConfigurePermissions(principal);
        }

    }

    public static class ManagePermissionsList extends PermissionsList {

        public ManagePermissionsList(IPlugin subject) {
            this(new ArrayList(),subject);
        }

        public ManagePermissionsList(ArrayList perms, IPlugin subject) {
            super(perms, subject);
        }

        @Override
        public ScopeType[] getAvailableScopeTypes() {
            if(ManagementSecurityUtils.isFolder(subject))
            {
                return ManagePermissions.folderScopeTypes;
            }
            if(ManagementSecurityUtils.MF_CONTAINER.equals(subject.getAttributes().getType()))
            {
                return ManagePermissions.containerScopeTypes;
            }
            return ManagePermissions.componentScopeTypes;
        }

        @Override
        public PermissionType[] getAvailablePermissionTypes() {
            return ManagePermissions.permissionTypes;
        }

        @Override
        public AbstractPermissions newPermissions(AbstractPermissions.Principal principal) {
            return new ManagePermissions(principal);
        }

    }

}
