/**
 * Copyright (c) 2002 Sonic Software Corporation. All Rights Reserved.
 *
 * This software is the confidential and proprietary information of Sonic
 * Software Corpoation. (Confidential Information).  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sonic.
 *
 * SONIC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SONIC SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 *
 * CopyrightVersion 1.0
 */
package com.sonicsw.ma.gui.plaf;

import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;

import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicTextFieldUI;

import com.sonicsw.ma.gui.util.BasicGuiAction;
import com.sonicsw.ma.gui.util.JBasicMenuItem;

public class EditTextFieldUI extends BasicTextFieldUI
{
    private MouseListener listener = null;


    public static ComponentUI createUI(JComponent c)
    {
        return new EditTextFieldUI();
    }

    public EditTextFieldUI()
    {
        super();
    }

    @Override
    public void installUI(JComponent c)
    {
        super.installUI(c);

        listener = new MouseAdapter()
        {
            @Override
            public void mousePressed(MouseEvent evt)
            {
                mouseReleased(evt);
            }

            @Override
            public void mouseReleased(MouseEvent evt)
            {
                if (evt.isPopupTrigger())
                {
                    JPopupMenu menu = new JPopupMenu();

                    menu.add(new JBasicMenuItem(new EditCutAction()));
                    menu.add(new JBasicMenuItem(new EditCopyAction()));
                    menu.add(new JBasicMenuItem(new EditPasteAction()));

                    menu.show((JComponent)evt.getSource(), evt.getX(), evt.getY());
                }
            }
        };

        c.addMouseListener(listener);
    }

    @Override
    public void uninstallUI(JComponent c)
    {
        super.uninstallUI(c);

        if (listener != null)
        {
            c.removeMouseListener(listener);
        }
    }

    //-------------------------------------------------------------------------
    //
    // Inner classes
    //
    //-------------------------------------------------------------------------

    class EditCopyAction extends BasicGuiAction
    {
        public EditCopyAction()
        {
            super("edit.copy");
        }

        @Override
        public void actionPerformed(ActionEvent evt)
        {
            getComponent().copy();

        }

        @Override
        public boolean isEnabled()
        {
            String sel = getComponent().getSelectedText();

            return ((sel != null) && (sel.trim().length() > 0));
        }
    }

    class EditCutAction extends BasicGuiAction
    {
        public EditCutAction()
        {
            super("edit.cut");
        }

        @Override
        public void actionPerformed(ActionEvent evt)
        {
            getComponent().cut();
        }

        @Override
        public boolean isEnabled()
        {
            String sel = getComponent().getSelectedText();

            return ((sel != null) && (sel.trim().length() > 0));
        }
    }

    class EditPasteAction extends BasicGuiAction
    {
        public EditPasteAction()
        {
            super("edit.paste");
        }

        @Override
        public void actionPerformed(ActionEvent evt)
        {
            getComponent().paste();
        }

        @Override
        public boolean isEnabled()
        {
            return (getComponent().isEnabled() && getComponent().isEditable());
        }
    }

}
