package com.sonicsw.ma.gui.propsheets;

import javax.swing.JPanel;
import javax.swing.JTabbedPane;

/**
 * The ITabbedDialog interface provides a common way of adding tabbed panel
 * support to any dialog.
 */
public interface ITabbedDialog
{
    /**
     * Adds a tab that contains the specified panel to the end of the tab panel.
     */
    public void addTabPanel(String name, JPanel panel);

    /**
     * Inserts a tab that contains the specified panel at the given position.
     */
    public void insertTabPanel(String name, JPanel panel, int pos);

    /**
     * Removes a tab panel from the property sheet.
     */
    public boolean removeTabPanel(String name);

    /**
     * Enables or disables the specified tab panel.
     */
    public void setEnableTabPanel(String name, boolean enable);

    /**
     * Get the JTabbedPane used by the dialog.
     */
    public JTabbedPane getTabbedPane();
}
