/**
 * Copyright (c) 2002 Sonic Software Corporation. All Rights Reserved.
 *
 * This software is the confidential and proprietary information of Sonic
 * Software Corpoation. (Confidential Information).  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sonic.
 *
 * SONIC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SONIC SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 *
 * CopyrightVersion 1.0
 */
package com.sonicsw.ma.gui.propsheets;

import javax.swing.JPanel;
import javax.swing.JTabbedPane;

import com.sonicsw.ma.gui.util.JMADialog;
import com.sonicsw.ma.gui.util.JMAFrame;
import com.sonicsw.ma.gui.util.JPartitionPanel;

public abstract class JPropSheetTabbedDialog extends JPropSheetDialog implements ITabbedDialog
{
    private JTabbedPane m_tab;

    public JPropSheetTabbedDialog(JMAFrame parent, String name, Class modelClass)
    {
        super(parent, name, modelClass);
    }

    public JPropSheetTabbedDialog(JMADialog parent, String name, Class modelClass)
    {
        super(parent, name, modelClass);
    }

    @Override
    protected void internalInitialize()
    {
        super.internalInitialize();

        m_tab = new JTabbedPane(JTabbedPane.TOP);
        m_tab.setBorder(new javax.swing.border.EmptyBorder(JPartitionPanel.BORDER_SIZE,JPartitionPanel.BORDER_SIZE,0,JPartitionPanel.BORDER_SIZE));

        getContentPane().add(m_tab);
    }

    //-------------------------------------------------------------------------
    //
    // ITabbedPropSheet Implementation
    //
    //-------------------------------------------------------------------------

    /**
     * Adds a tab that contains the specified panel to the end of the tab panel.
     */
    @Override
    public void addTabPanel(String name, JPanel panel)
    {
        m_tab.addTab(name, panel);
    }

    /**
     * Inserts a tab that contains the specified panel at the given position.
     */
    @Override
    public void insertTabPanel(String name, JPanel panel, int pos)
    {
        m_tab.insertTab(name, null, panel, null, pos);
    }

    /**
     * Removes a tab panel from the property sheet.
     */
    @Override
    public boolean removeTabPanel(String name)
    {
        int index = m_tab.indexOfTab(name);

        if (index >= 0)
        {
            m_tab.removeTabAt(index);
        }

        return (index >= 0);
    }

    /**
     * Enables or disables the specified tab panel.
     */
    @Override
    public void setEnableTabPanel(String name, boolean enable)
    {
        int index = m_tab.indexOfTab(name);

        if (index >= 0)
        {
            m_tab.setEnabledAt(index, enable);
        }
    }

    /**
     * Get the JTabbedPane used by the PropertySheet
     */
    @Override
    public JTabbedPane getTabbedPane()
    {
        return m_tab;
    }

}
