package com.sonicsw.ma.gui.propsheets;

import modelobjects.framework.ViewValueConversionException;
import modelobjects.framework.ViewValueConverter;

import com.sonicsw.ma.gui.config.propsheets.JConfigDialog;
import com.sonicsw.ma.plugin.IPluginContext;
import com.sonicsw.mx.config.IConfigBean;
import com.sonicsw.mx.config.IConfigPath;

public class RefDirToStringFromAnotherFieldConverter implements ViewValueConverter
{
    private IConfigPath    m_path;
    private JConfigDialog  m_sheet;
    private IPluginContext m_context;

    public RefDirToStringFromAnotherFieldConverter()
    {
    }

    public RefDirToStringFromAnotherFieldConverter(JConfigDialog sheet, IConfigPath path)
    {
        m_path  = path;
        m_sheet = sheet;
    }

    public void setPluginContext(IPluginContext context)
    {
        m_context = context;
    }

    // Return a reference to the element named in viewValue or complain
    // if there is no such element

    @Override
    public Object viewValueToModel(Object viewValue)
       throws ViewValueConversionException
    {
        if ((viewValue == null) || (viewValue.equals("")))
        {
            return null;
        }

        // check that the string entered corresponds to a valid directory
        if (viewValue instanceof String)
        {
            String  stringValue = (String)viewValue;
            boolean foundObject = false;

            try
            {
                m_context.getConfigContext().getConfigServer().loadConfigElement(stringValue);

                return stringValue;
            }
            catch (Exception e)
            {
                // the directory doesn't really exist, throw ViewValueConversionException
                throw new ViewValueConversionException("Element " + stringValue + " does not exist", e);
            }
        }
        else
        {
            throw new ViewValueConversionException("expected a string");
        }
    }

    // return the name of the directory
    @Override
    public Object modelValueToView(Object modelValue)
        throws ViewValueConversionException
    {
        // Whatever the value is, take the value from "another field"
        try
        {
// v5.0
/*
            ConfigBeanModel model = (ConfigBeanModel)m_sheet.getModel();
            IConfigBean     bean  = (IConfigBean)model.getData();
            String          dirString = (String)bean.getAttribute(m_path);

            if ((dirString != null) && (dirString.length() > 0))
            {
                // Get the parent directory
                String parentDir = dirString.substring(0, dirString.lastIndexOf("/"));
                // We expect one descriptor element in this parent directory
                IElementIdentity[] descriptors = m_context.getConnectionInfo().getDirectoryService().listElements(parentDir);
                // Take the descriptor element and return the corresponding view name
                if ((descriptors != null) && (descriptors.length > 0))
                {
                    String[] viewNames = m_context.getViewManager().linkedObjectIDToPath(descriptors[0].getName());

                    if ((viewNames != null) && (viewNames.length > 0))
                        return viewNames[0];
                }
            }
*/
            return null;
        }
        catch (Exception e)
        {
            throw new ViewValueConversionException(e, m_sheet.getModelAspectId(m_path));
        }
    }

    /**
     *  Returns an array of all the String values that may be used as view
     *  aspect values, or null if no such constraint applies.
     */
    @Override
    public String[] getViewStringValues()
    {
        return null;
    }

    /**
     *  Returns whether or not conversion from view values to model values
     *  is supported by the ViewValueConverter.  If not, ViewAspectAdapters
     *  using this ViewValueConverter cannot be edited.
     */
    @Override
    public boolean isViewValueToModelSupported()
    {
        return true;
    }

    /**
     *  Return the model type returned by viewValueToModel()
     */
    @Override
    public Class getModelClass()
    {
        return IConfigBean.class;
    }

    /**
     *  Return the view type returned by modelValueToView()
     */
    @Override
    public Class getViewClass()
    {
        return String.class;
    }
}