package com.sonicsw.ma.gui.propsheets;

import modelobjects.framework.ViewValueConversionException;
import modelobjects.framework.ViewValueConverter;

import com.sonicsw.ma.gui.config.propsheets.JConfigDialog;
import com.sonicsw.ma.plugin.ConfigBeanModel;
import com.sonicsw.ma.plugin.IPluginContext;
import com.sonicsw.mx.config.IConfigBean;
import com.sonicsw.mx.config.IConfigPath;

public class RefToStringFromAnotherFieldConverter implements ViewValueConverter
{
    private IConfigPath    m_path;
    private JConfigDialog  m_sheet;
    private IPluginContext m_context;

    public RefToStringFromAnotherFieldConverter()
    {
    }

    public RefToStringFromAnotherFieldConverter(JConfigDialog sheet, IConfigPath path)
    {
        m_path = path;
        m_sheet = sheet;
    }

    public void setConfigContext(IPluginContext context)
    {
        m_context = context;
    }

    // Return a reference to the element named in viewValue or complain
    // if there is no such element

    @Override
    public Object viewValueToModel(Object viewValue)
        throws ViewValueConversionException
    {
        if ((viewValue == null) || (viewValue.equals("")))
        {
            return null;
        }

        if (viewValue instanceof String)
        {
            try
            {
                // Test that there's really a DS element behind this view name
                m_context.getConfigContext().getConfigServer().loadConfigElement((String)viewValue);

                return (String)viewValue;
            }
            catch (Exception e)
            {
                // the object doesn't really exist, throw ViewValueConversionException
                throw new ViewValueConversionException("Element " + (String)viewValue + " does not exist", e);
            }
        }
        else
        {
            throw new ViewValueConversionException("expected a string");
        }

    }

    // return the name of the element
    @Override
    public Object modelValueToView(Object modelValue)
         throws ViewValueConversionException
    {
        // Whatever the value is, take the value from "another field"

        ConfigBeanModel model = (ConfigBeanModel)m_sheet.getModel();
        IConfigBean     bean  = (IConfigBean)model.getData();
        Object          value = bean.getAttribute(m_path);

        if (value != null)
        {
            if (value instanceof IConfigBean)
            {
                String name = ((IConfigBean)value).getName();

                // return the view name of the DS name
                String[] viewNames = new String[] { name };

                if ((viewNames != null) && (viewNames.length > 0))
                {
                    return viewNames[0];
                }

                return null;
            }
            return value.toString();
        }
        return null;
    }

    /**
     *  Returns an array of all the String values that may be used as view
     *  aspect values, or null if no such constraint applies.
     */
    @Override
    public String[] getViewStringValues()
    {
        return null;
    }

    /**
     *  Returns whether or not conversion from view values to model values
     *  is supported by the ViewValueConverter.  If not, ViewAspectAdapters
     *  using this ViewValueConverter cannot be edited.
     */
    @Override
    public boolean isViewValueToModelSupported()
    {
        return true;
    }

    /**
     *  Return the model type returned by viewValueToModel()
     */
    @Override
    public Class getModelClass()
    {
        return String.class;
    }

    /**
     *  Return the view type returned by modelValueToView()
     */
    @Override
    public Class getViewClass()
    {
        return String.class;
    }


}