package com.sonicsw.ma.gui.propsheets;

import modelobjects.framework.ViewValueConversionException;
import modelobjects.framework.ViewValueConverter;

import com.sonicsw.ma.gui.config.propsheets.JConfigDialog;
import com.sonicsw.mx.config.IConfigBean;
import com.sonicsw.mx.config.IConfigPath;

public class StringToStringFromAnotherFieldConverter implements ViewValueConverter
{
    private IConfigPath   m_path;
    private JConfigDialog m_sheet;

    public StringToStringFromAnotherFieldConverter()
    {
    }

    public StringToStringFromAnotherFieldConverter(JConfigDialog sheet, IConfigPath path)
    {
        m_path  = path;
        m_sheet = sheet;
    }

    @Override
    public Object viewValueToModel(Object viewValue)
        throws ViewValueConversionException
    {
        if ((viewValue == null) || (viewValue.equals("")))
        {
            return null;
        }

        if (viewValue instanceof String)
        {
            return viewValue;
        }
        else
        {
            throw(new ViewValueConversionException("expected a string"));
        }
    }

    @Override
    public Object modelValueToView(Object modelValue)
        throws ViewValueConversionException
    {
        // Whatever the value is, take the value from "another field"

        Object fieldValue = ((IConfigBean)m_sheet.getModel()).getAttribute(m_path);
        if (fieldValue != null)
        {
            if (fieldValue instanceof com.sonicsw.mf.common.config.Reference)
            {
                return ((com.sonicsw.mf.common.config.Reference)fieldValue).getElementName();
            }

            return fieldValue.toString();
        }
        return null;
    }

    /**
     *  Returns an array of all the String values that may be used as view
     *  aspect values, or null if no such constraint applies.
     */
    @Override
    public String[] getViewStringValues()
    {
        return null;
    }

    /**
     *  Returns whether or not conversion from view values to model values
     *  is supported by the ViewValueConverter.  If not, ViewAspectAdapters
     *  using this ViewValueConverter cannot be edited.
     */
    @Override
    public boolean isViewValueToModelSupported()
    {
        return true;
    }

    /**
     *  Return the model type returned by viewValueToModel()
     */
    @Override
    public Class getModelClass()
    {
        return String.class;
    }

    /**
     *  Return the view type returned by modelValueToView()
     */
    @Override
    public Class getViewClass()
    {
        return String.class;
    }

}
