/**
 * Copyright (c) 2002 Sonic Software Corporation. All Rights Reserved.
 *
 * This software is the confidential and proprietary information of Sonic
 * Software Corpoation. (Confidential Information).  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sonic.
 *
 * SONIC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SONIC SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 *
 * CopyrightVersion 1.0
 */
package com.sonicsw.ma.gui.runtime;

import javax.swing.JTextField;

import modelobjects.framework.IntToStringConverter;

import com.sonicsw.ma.gui.runtime.propsheets.JRuntimeDialog;
import com.sonicsw.ma.gui.util.JPartitionPanel;

/**
 * <p>Title: JMetricsPanel.java</p>
 * <p>Description: A panel that presents the user with fields that allow the
 *                 settable Metrics and Collection intervals to be configured.</p>
 * <p>Copyright: Copyright (c) 2004</p>
 * <p>Company: Sonic Software</p>
 * @author hjones
 * @version 1.0
 */
public class JMetricsPanel extends JPartitionPanel
{
    public static final String ATTRIBUTE_METRICS_REFRESH_INTERVAL    = "MetricsRefreshInterval";
    public static final String ATTRIBUTE_METRICS_COLLECTION_INTERVAL = "MetricsCollectionInterval";

    private JTextField m_metricsRefreshInterval    = new JTextField();
    private JTextField m_metricsCollectionInterval = new JTextField();    

    public JMetricsPanel()
    {
        super("");
    }

    /**
     * Call to initialize the UI portion of the panel.
     *
     * @param dialog  The parent (dialog) inwhich the panel is being hosted.
     */
    public void initUI(JRuntimeDialog dialog)
    {
        addRow(dialog.getResourceLabel(ATTRIBUTE_METRICS_REFRESH_INTERVAL),
               m_metricsRefreshInterval,
               dialog.getResourceUnit("seconds"));

        addRow(dialog.getResourceLabel(ATTRIBUTE_METRICS_COLLECTION_INTERVAL),
               m_metricsCollectionInterval,
               dialog.getResourceUnit("minutes"));
    }

    /**
     * Call to initialize the Form / Model porition of the panel.
     *
     * @param dialog  The parent (dialog) inwhich the panel is being hosted.
     */
    public void initForm(JRuntimeDialog dialog)
    {
        dialog.createJTextFieldAdapter(ATTRIBUTE_METRICS_REFRESH_INTERVAL,
                                       m_metricsRefreshInterval,
                                       new IntToStringConverter());

        dialog.createJTextFieldAdapter(ATTRIBUTE_METRICS_COLLECTION_INTERVAL,
                                       m_metricsCollectionInterval,
                                       new IntToStringConverter());
    }

    /**
     * Called to perform any cleanup / pre-finalization code (if necessary).
     */
    public void cleanup()
    {
    }

}
