package com.sonicsw.ma.gui.runtime;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

import javax.swing.Action;
import javax.swing.JLabel;
import javax.swing.JTabbedPane;

import com.sonicsw.ma.gui.GUIMonitorPluginListener;
import com.sonicsw.ma.gui.IApplication;
import com.sonicsw.ma.gui.MgmtConsole;
import com.sonicsw.ma.gui.WorkspaceWindow;
import com.sonicsw.ma.gui.util.JMADialog;
import com.sonicsw.ma.gui.util.JMAFrame;
import com.sonicsw.ma.gui.util.JMAInternalFrame;
import com.sonicsw.ma.gui.util.JWaitCursor;
import com.sonicsw.ma.gui.util.ResourceManager;
import com.sonicsw.ma.plugin.IMonitorPlugin;

public final class JMonitorDialog extends JMADialog
{
    // Its important that these classes are fully qualified because they are
    // created / handled using "java reflection" and therefore escape full
    // compile-time validation.
    //
    private static final Class[] TAB_CLASS = new Class[]
    {
        com.sonicsw.ma.gui.runtime.notifications.JNotificationsPanel.class,
        com.sonicsw.ma.gui.runtime.metrics.JMetricsPanel.class,
        com.sonicsw.ma.gui.runtime.notifications.JForwardedNotificationsPanel.class,
        com.sonicsw.ma.gui.runtime.metrics.JAggregateMetricPanel.class,
        com.sonicsw.ma.gui.config.metrics.JMetricsPanel.class,
    };

    private JTabbedPane      m_tab;
    private JMAInternalFrame m_parentInternal;
    private HashMap          m_panels;
    private GUIMonitorPluginListener listener;

    public JMonitorDialog(JMAFrame parent, JMAInternalFrame parentInternal)
        throws Exception
    {
        super(parent, "manage-tools");

        setModal(false);

        m_panels = new HashMap();
        m_parentInternal = parentInternal;

        listener = new GUIMonitorPluginListener()
                {
                    @Override
                    public void guiMonitorPluginChanged(IMonitorPlugin plugin)
                    {
                        JWaitCursor wc = new JWaitCursor(MgmtConsole.getMgmtConsole());

                        try
                        {
                            pluginChange(plugin);
                        }
                        finally
                        {
                            wc.release();
                        }
                    }
                };
        ((WorkspaceWindow)m_parentInternal).addGUIMonitorPluginListener(listener);
    }

    @Override
    public String getTitle()
    {
        return ResourceManager.getString(getClass(), "dialog." + m_name + ".title");
    }

    @Override
    public Dimension getPreferredSize()
    {
        return new Dimension(300, 350);
    }

    public void setVisibleMonitor(String monitorId)
    {
        JAbstractMonitorPanel panel = getPanel(monitorId);

        if (panel != null)
        {
            int index = m_tab.indexOfTab(panel.getTabTitle());

            if (index >= 0)
            {
                m_tab.setSelectedIndex(index);
            }
        }
    }

    public WorkspaceWindow getWorkspaceWindow()
    {
        return (WorkspaceWindow)m_parentInternal;
    }

    @Override
    public void maInitialize()
    {
        m_tab = new JMonitorTabbedPane(JTabbedPane.NORTH);

        getContentPane().add(m_tab, BorderLayout.CENTER);

        try
        {
            for (int i = 0; i < TAB_CLASS.length; i++)
            {
                JAbstractMonitorPanel panel = (JAbstractMonitorPanel)TAB_CLASS[i].newInstance();

                panel.maInitialize();

                m_panels.put(panel.getTabTitle(), panel);
            }
        }
        catch (Exception e)
        {
            MgmtConsole.getMgmtConsole().notifyMessage(IApplication.MESSAGE_ERROR,
                "Failed to initialize monitor", e, false);
        }
    }

    @Override
    public void maCleanup()
    {
        Iterator i = m_panels.keySet().iterator();

        while (i.hasNext())
        {
            String                tabTitle = (String)i.next();
            JAbstractMonitorPanel panel    = (JAbstractMonitorPanel)m_panels.get(tabTitle);

            panel.maCleanup();
        }

            ((WorkspaceWindow)m_parentInternal).removeGUIMonitorPluginListener(listener);
            m_panels.clear();
    }

    @Override
    public Action[] getButtonActions()
    {
        return new Action[] { }; // We don't want any button bar at the bottom!
    }

    public void pluginChange(IMonitorPlugin plugin)
    {
        Iterator i = m_panels.entrySet().iterator();

        while (i.hasNext())
        {
            Map.Entry             entry = (Map.Entry)i.next();
            JAbstractMonitorPanel panel = (JAbstractMonitorPanel)entry.getValue();
            boolean               visible = ((plugin != null) && plugin.isMonitorSupported(panel.getMonitorId()));

            setTabVisibility(panel, visible);

            ((JAbstractMonitorPanel)entry.getValue()).changeModel(plugin);
        }

        StringBuffer title = new StringBuffer();
        title.append(ResourceManager.getString(getClass(), "dialog." + m_name + ".title"));

        String path = (plugin != null) ? plugin.getPluginPath() : null;

        if ((path != null)  && (path.trim().length() > 0))
        {
            title.append(" - ").append(path);
        }

        setTitle(title.toString());
    }

    private JAbstractMonitorPanel getPanel(String monitorId)
    {
        JAbstractMonitorPanel res = null;
        Iterator              i   = m_panels.entrySet().iterator();

        if (monitorId != null)
        {
            while (i.hasNext())
            {
                Map.Entry             entry = (Map.Entry)i.next();
                JAbstractMonitorPanel panel = (JAbstractMonitorPanel)entry.getValue();

                if (panel.getMonitorId().equals(monitorId))
                {
                    res = panel;
                    break;
                }
            }
        }

        return res;
    }

    /**
     * Adds or removes a tab (panel) from the tabbed pane depending on the
     * state parameter.
     *
     * Tab ordering is enforced to match the order of the TAB_CLASS array.
     *
     * @param panel  The panel who's visiblity is changing
     * @param state  The state (show=true/hide) we want this panel in.
     */
    private void setTabVisibility(JAbstractMonitorPanel panel, boolean state)
    {
        int index = m_tab.indexOfTab(panel.getTabTitle());

        if (state)
        {
            if (index < 0)
            {
                if (panel.getClass() == TAB_CLASS[0])
                {
                    m_tab.insertTab(panel.getTabTitle(), panel.getIcon(), panel, null, 0);
                }
                else
                if (panel.getClass() == TAB_CLASS[TAB_CLASS.length-1])
                {
                    m_tab.insertTab(panel.getTabTitle(), panel.getIcon(), panel, null, m_tab.getTabCount());
                }
                else
                {
                    Class findClass = null;

                    for (int i = 1; i < TAB_CLASS.length - 2; i++)
                    {
                        if (panel.getClass() == TAB_CLASS[i])
                        {
                            findClass = TAB_CLASS[i+1];
                            break;
                        }
                    }

                    int findIndex = 0;

                    for (int j = 0; j < m_tab.getTabCount(); j++)
                    {
                        Component tabPanel = m_tab.getComponentAt(j);

                        if (tabPanel.getClass() == findClass)
                        {
                            findIndex = j;
                            break;
                        }
                    }

                    m_tab.insertTab(panel.getTabTitle(), panel.getIcon(), panel, null, findIndex);
                }
            }
        }
        else
        {
            if (index >= 0)
            {
                m_tab.remove(index);
            }
        }
    }

    class JMonitorTabbedPane extends JTabbedPane
    {
        public JMonitorTabbedPane(int tabPlacement)
        {
            super(tabPlacement);
        }

        @Override
        protected void paintComponent(Graphics g)
        {
            super.paintComponent(g);

            if (getTabCount() == 0)
            {
                JLabel label = new JLabel("No options");
                label.setSize((int)g.getClipBounds().getWidth(),
                              (int)g.getClipBounds().getHeight());
                label.setHorizontalAlignment(JLabel.CENTER);
                label.paint(g);
            }
        }
    }
}
