/**
 * Copyright (c) 2002 Sonic Software Corporation. All Rights Reserved.
 *
 * This software is the confidential and proprietary information of Sonic
 * Software Corpoation. (Confidential Information).  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sonic.
 *
 * SONIC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SONIC SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 *
 * CopyrightVersion 1.0
 */

package com.sonicsw.ma.gui.runtime;

import java.awt.event.ActionEvent;

import javax.swing.Action;
import javax.swing.JOptionPane;

import com.sonicsw.ma.gui.MgmtConsole;
import com.sonicsw.ma.gui.util.BasicGuiAction;
import com.sonicsw.ma.plugin.IPlugin;
import com.sonicsw.ma.plugin.IRuntimePlugin;

import com.sonicsw.mf.common.runtime.IComponentState;
import com.sonicsw.mf.common.runtime.IContainerState;
import com.sonicsw.mf.common.runtime.IState;
import com.sonicsw.mf.common.runtime.impl.RemoteCallResult;

public class RuntimeAction extends BasicGuiAction
{
    protected IRuntimePlugin m_plugin;
    protected String         m_prompt;
    protected String         m_action;
    protected int            m_timeoutFactor;

    public RuntimeAction(IRuntimePlugin plugin, String name, String action)
    {
        this(plugin, name, action, null);
    }

    public RuntimeAction(IRuntimePlugin plugin, String name, String action, String prompt)
    {
        this(plugin, name, action, prompt, -1);
    }

    public RuntimeAction(IRuntimePlugin plugin, String name, String action, String prompt, int timeoutFactor)
    {
        super(name);

        m_plugin = plugin;
        m_prompt = prompt;
        m_action = action;
        m_timeoutFactor = timeoutFactor;
    }

    @Override
    public void actionPerformed(ActionEvent evt)
    {
        int ok = JOptionPane.YES_OPTION;

        if(m_prompt != null)
        {
            ok = MgmtConsole.getMgmtConsole().showConfirmDialog(m_prompt,
                            "Perform operation",
                            JOptionPane.QUESTION_MESSAGE,
                            JOptionPane.YES_NO_OPTION);
        }

        if(ok == JOptionPane.YES_OPTION)
        {
            invokeAction();
        }
    }

    @Override
    public boolean isEnabled()
    {
        boolean res   = true;
        IState  state = ((IPlugin)m_plugin).getAttributes().getState();

        // A collection doesn't have any state so we hard-code the action
        // to always be enabled.
        //

        /* AJB
        if (m_plugin instanceof CollectionPlugin)
            return true;
        */

        if (state == null)
        {
            res = false;
        }
        else
        {
            if (state instanceof IContainerState)
            {
                if (m_action.equals("start") && (state.getState() == IContainerState.STATE_ONLINE))
                {
                    res = false;
                }

                if (m_action.equals("stop") && (state.getState() == IContainerState.STATE_OFFLINE))
                {
                    res = false;
                }
            }

            if (state instanceof IComponentState)
            {
                if (m_action.equals("start") && (state.getState() == IComponentState.STATE_ONLINE))
                {
                    res = false;
                }

                if (m_action.equals("stop") && (state.getState() == IComponentState.STATE_OFFLINE))
                {
                    res = false;
                }
            }
        }
        return res;
    }

    protected void invokeAction()
    {
        invokeAction(new Object[] {}, new String[] {});
    }

    protected void invokeAction(Object[] args, String[] sigs)
    {
        if(m_action == null)
        {
            System.err.println("RuntimeAction::invokeAction : Action not defined for " + getValue(Action.NAME));
            return;
        }
        invokeAction(m_action, args, sigs, m_timeoutFactor);
    }

    protected void invokeAction(Object[] args, String[] sigs, int timeout)
    {
        if(m_action == null)
        {
            System.err.println("RuntimeAction::invokeAction : Action not defined for " + getValue(Action.NAME));
            return;
        }
        invokeAction(m_action, args, sigs, timeout);
    }

    protected void invokeAction(final String action,
                                final Object[] args,
                                final String[] sigs)
    {
        invokeAction(m_action, args, sigs, m_timeoutFactor);
    }

    protected void invokeAction(final String action,
                                final Object[] args,
                                final String[] sigs,
                                final int timeout)
    {
        if(m_plugin == null)
        {
            System.err.println("RuntimeAction::invokeAction : Plugin not defined for " + getValue(Action.NAME));
            return;
        }

        Thread th = new Thread(new Runnable()
        {
            @Override
            public void run()
            {
                RemoteCallResult ret = (RemoteCallResult) m_plugin.invokeAction(action, args, sigs, timeout);
                if(ret != null && ret.isSuccessful() == false)
                {
                    MgmtConsole.getMgmtConsole().displayMessage(JOptionPane.ERROR_MESSAGE,ret.getOutput(),true);
                }
            }
        } );
        th.start();
    }
}