/**
 * Copyright (c) 2002 Sonic Software Corporation. All Rights Reserved.
 *
 * This software is the confidential and proprietary information of Sonic
 * Software Corpoation. (Confidential Information).  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sonic.
 *
 * SONIC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SONIC SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 *
 * CopyrightVersion 1.0
 */

package com.sonicsw.ma.gui.runtime;

import java.util.ArrayList;
import java.util.List;

import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JSeparator;

import com.sonicsw.ma.gui.action.RuntimeClearLogAction;
import com.sonicsw.ma.gui.action.RuntimeSaveLogFileAction;
import com.sonicsw.ma.gui.domain.DomainConnectionModel;
import com.sonicsw.ma.gui.propsheets.JPropSheetDialog;
import com.sonicsw.ma.gui.util.BasicGuiAction;
import com.sonicsw.ma.gui.util.Helper;
import com.sonicsw.ma.gui.util.JBasicMenu;
import com.sonicsw.ma.gui.util.JBasicMenuItem;
import com.sonicsw.ma.plugin.IPluginContext;
import com.sonicsw.ma.plugin.PluginAttributes;

public class RuntimeDomainFolderPlugin extends RuntimeFolderPlugin
{
    public static final String PLUGIN_NAME = "Managed Objects";
    public static final String PLUGIN_TYPE = "RuntimeDomain";
    public static final String DISPLAY_TYPE = PLUGIN_TYPE;

    private static final Object[][] ATTRIBUTES =
    {
        { PluginAttributes.TYPE,         PLUGIN_TYPE },
        { PluginAttributes.IS_SYSTEM,    "true" },
        { PluginAttributes.DISPLAY_TYPE, DISPLAY_TYPE }
    };

    @Override
    public String getPluginName()
    {
        return PLUGIN_NAME;
    }

    @Override
    public String getPluginPath()
    {
        return "/";
    }

    private RuntimeDomainFolderModel m_model = null;

    public RuntimeDomainFolderPlugin(IPluginContext context)
    {
        super(context, null, null);

        getAttributes().put(ATTRIBUTES);
    }

    @Override
    public void dispose()
    {
        m_model = null;
    }

	@Override
    protected JComponent[] getSystemMenuItems() 
	{
	   	JComponent[] compMenuItems = super.getSystemMenuItems();
	   	//Add Log Operations sub menu to Systems Menu 
	    JMenuItem logMenu = new JBasicMenu(new LogAction("runtime.log.central"));
        JComponent[] ops = getLogMenuItems();
        for (int i = 0; i < ops.length; i++)
        {
            logMenu.add(ops[i]);
        }
	    return Helper.combineMenu(compMenuItems,new JComponent[] { new JSeparator(), logMenu },false);
   	}
    private class LogAction extends BasicGuiAction
    {
	    public LogAction(String resId) 
	    {
		    	super(resId);
		}
	}
	protected JComponent[] getLogMenuItems()
    {
    	  ArrayList list = new ArrayList();
    	  list.add(new JBasicMenuItem(new RuntimeViewLogAction(this)));
          list.add(new JBasicMenuItem(new RuntimeClearLogAction(this)));
          list.add(new JBasicMenuItem(new RuntimeSaveLogFileAction(this)));
          
          return (JComponent[]) list.toArray(new JComponent[list.size()]);
    }

    @Override
    public JPropSheetDialog getPropSheetDialog()
    {
        return new RuntimeDomainFolderDialog(getPluginContext().getMgmtConsole());
    }

    @Override
    public Object getModel()
    {
        if (m_model == null)
        {
            m_model = new RuntimeDomainFolderModel(this, getPluginContext());
        }

        return m_model;
    }

    @Override
    public List getToolTipList()
    {
        DomainConnectionModel model = getPluginContext().getConnectionInfo();

        List list = new ArrayList();

		list.add(formatToolTipText("Connection", model.getConnectionName()));
		list.add(formatToolTipText("Domain",     model.getDomainName()));
		list.add(formatToolTipText("URL",        model.getUrl()));

        String userName = model.getUserName();
        if ((userName != null) && (userName.trim().length() > 0))
        {
            list.add(formatToolTipText("User Name", userName));
        }

        return list;
    }
}