/**
 * Copyright (c) 2002 Sonic Software Corporation. All Rights Reserved.
 *
 * This software is the confidential and proprietary information of Sonic
 * Software Corpoation. (Confidential Information).  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sonic.
 *
 * SONIC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SONIC SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 *
 * CopyrightVersion 1.0
 */

package com.sonicsw.ma.gui.runtime;

import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;

import com.sonicsw.ma.gui.table.ObjectColumn;
import com.sonicsw.ma.gui.table.PluginContentPane;
import com.sonicsw.ma.gui.table.PluginNameTableCellRenderer;
import com.sonicsw.ma.gui.table.PluginTypeTableCellRenderer;
import com.sonicsw.ma.plugin.AbstractGUIPlugin;
import com.sonicsw.ma.plugin.IPlugin;
import com.sonicsw.ma.plugin.PluginAttributes;

import com.sonicsw.mf.common.runtime.IContainerState;
import com.sonicsw.mf.common.runtime.IState;

public class RuntimeFolderContentPane extends PluginContentPane
{
    public RuntimeFolderContentPane(IPlugin plugin)
    {
        super(plugin);
    }

    @Override
    public TableColumn[] getColumns()
    {
        return new TableColumn[]
        {
            new LocalColumn(LocalColumn.NAME,  "Name",  40, new PluginNameTableCellRenderer()),
            new LocalColumn(LocalColumn.TYPE,  "Type",  20, new PluginTypeTableCellRenderer()),
            new LocalColumn(LocalColumn.HOST,  "Host",  20),
            new LocalColumn(LocalColumn.STATE, "State", 20),
        };
    }

    static class LocalColumn extends ObjectColumn
    {
        public static final int NAME  = 0;
        public static final int TYPE  = 1;
        public static final int HOST  = 2;
        public static final int STATE = 3;

        public LocalColumn(int modelIndex, String name, int initialWidth)
        {
            this(modelIndex, name, initialWidth, null);
        }

        public LocalColumn(int modelIndex, String name, int initialWidth, TableCellRenderer renderer)
        {
            super(modelIndex, name, initialWidth);

            if (renderer != null)
            {
                setTableCellRenderer(renderer);
            }
        }

        private void setTableCellRenderer(TableCellRenderer renderer) {
            setCellRenderer(renderer);
        }
        
        @Override
        public Object getColumnValue(Object rowModel)
        {
            AbstractGUIPlugin plugin = (AbstractGUIPlugin)rowModel;
            Object value = null;

            if (plugin != null)
            {
                PluginAttributes attributes = plugin.getAttributes();
                IState           state      = (IState)attributes.getState();

                switch (getModelIndex())
                {
                    case NAME  : value = plugin.getPluginName(); break;
                    case TYPE  : value = attributes.getDisplayType(); break;
                    case HOST  :
                    {
                        if (state == null)
                        {
                            value = (plugin instanceof RuntimeFolderPlugin) ? "" : "Unknown";
                        }
                        else
                        if (state instanceof IContainerState)
                        {
                            value = ((IContainerState)state).getContainerHost();
                        }

                        break;
                    }
                    case STATE :
                    {
                        if (state == null)
                        {
                            value = (plugin instanceof RuntimeFolderPlugin) ? "" : "Unknown";
                        }
                        else
                        {
                            value = state.getStateString();
                        }

                        break;
                    }
                }
            }

            return value;
        }
    }
}
