/**
 * Copyright (c) 2002 Sonic Software Corporation. All Rights Reserved.
 *
 * This software is the confidential and proprietary information of Sonic
 * Software Corpoation. (Confidential Information).  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sonic.
 *
 * SONIC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SONIC SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 *
 * CopyrightVersion 1.0
 */

package com.sonicsw.ma.gui.runtime;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

import javax.swing.JProgressBar;

import com.sonicsw.ma.gui.MgmtConsole;
import com.sonicsw.ma.gui.action.FolderPluginExpandAction;
import com.sonicsw.ma.gui.file.FileFolderDialog;
import com.sonicsw.ma.gui.file.FileFolderPluginModel;
import com.sonicsw.ma.gui.propsheets.JPropSheetDialog;
import com.sonicsw.ma.gui.table.IContentPane;
import com.sonicsw.ma.gui.util.BasicAction;
import com.sonicsw.ma.gui.util.Helper;
import com.sonicsw.ma.plugin.IPlugin;
import com.sonicsw.ma.plugin.IPluginContext;
import com.sonicsw.ma.plugin.IRuntimePluginFactory;
import com.sonicsw.ma.plugin.PluginAttributes;
import com.sonicsw.mx.config.ConfigServerUtility;
import com.sonicsw.mx.config.IConfigServer;

import com.sonicsw.mf.common.config.IElementIdentity;

public class RuntimeFolderPlugin extends AbstractRuntimePlugin
{
    private static final String DISPLAY_TYPE = "Folder";

    private static final Object[][] ATTRIBUTES =
    {
        { PluginAttributes.DISPLAY_TYPE,     DISPLAY_TYPE },
        { PluginAttributes.IS_CHILD_BEARING, Boolean.TRUE },
    };

    private FileFolderPluginModel m_model = null;

    public RuntimeFolderPlugin(IPluginContext context, String name, Map data)
    {
        super(context, name, data);

        getAttributes().put(ATTRIBUTES);
    }

    @Override
    public void dispose()
    {
        m_model = null;
    }

    @Override
    public BasicAction getDefaultAction()
    {
        return new FolderPluginExpandAction(this);
    }

    @Override
    public boolean expand()
    {
        JProgressBar bar = MgmtConsole.getMgmtConsole().getStatusBar().getProgressBar();

        try
        {
			String path = getPluginPath();
			IConfigServer server = getPluginContext().getConfigContext().getConfigServer();
			Set childSet = server.list(path);
			Iterator i = (childSet != null) ? childSet.iterator() : null;
			int nPluginCount = (childSet != null) ? childSet.size() : 0;
			int nCount = 0;

            if (bar != null)
            {
                bar.setMinimum(0);
                bar.setMaximum(nPluginCount);
                bar.setVisible(true);
            }

            while ((i != null) && i.hasNext())
            {
                // Now try and create the child plugin...
                HashMap row = (HashMap)i.next();
                MgmtConsole.getMgmtConsole().notifyMessage(MgmtConsole.MESSAGE_PROGRESS,
                    "Loading runtime element " + ++nCount + " of " + nPluginCount, null, false);
                if (bar != null)
                {
                    bar.setValue(nCount);
                }
                addChildPlugin(createChildPlugin(null, row), row);
            }
        }
        catch (Exception e)
        {
            MgmtConsole.getMgmtConsole().notifyMessage(MgmtConsole.MESSAGE_ERROR,
                "RuntimeFolderPlugin::expand failed", e, false);
        }
        finally
        {
            if (bar != null)
            {
                bar.setVisible(false);
                MgmtConsole.getMgmtConsole().getStatusBar().releaseProgressBar();
            }
        }
        return true;
    }

    @Override
    protected IPlugin createChildPlugin(String strName, Map metaAttributes)
    {
        IPlugin plugin   = null;
        String  metaName = null;
        String  fullName = null;
        boolean isFolder = false;

        try
        {
            if (metaAttributes.containsKey(IConfigServer.FOLDER_NAME))
            {
                String folderName = (String) metaAttributes.remove(IConfigServer.FOLDER_NAME);

                int folderIndex = folderName.lastIndexOf('/');
                metaName = folderName.substring(folderIndex + 1);

                isFolder = true;
            }
            else if (metaAttributes.containsKey(IConfigServer.ELEMENT_IDENTITY))
            {
                IElementIdentity eId = (IElementIdentity) metaAttributes.remove(IConfigServer.ELEMENT_IDENTITY);
                String[] comp = eId.getNameComponents();

                metaName = comp[comp.length - 1];
                fullName = eId.getName();
            }
            else
            {
                return null;
            }

            if (metaAttributes.containsKey(ConfigServerUtility.TYPE))
            {
                String type     = (String)metaAttributes.get(ConfigServerUtility.TYPE);
                String cVersion = (String)metaAttributes.get(ConfigServerUtility.CONFIG_VERSION);
                String pVersion = (String)metaAttributes.get(ConfigServerUtility.PRODUCT_VERSION);

                IRuntimePluginFactory factory = getPluginContext().getRuntimeContext().getPluginFactory(type, cVersion, pVersion);

                if (factory != null && factory.getAttributes().isRuntimeRoot())
                {
                    Helper.logDebugMessage("RuntimeFolderPlugin::createChildPlugin(" + metaName + " " + type + " c=" + cVersion + " p=" + pVersion + ")");

                    // get the state info for all components in this container
                    // and put the state into the meta attributes
                    metaAttributes.put(PluginAttributes.STATE,
                                       getPluginContext().getConnectionInfo().getAgentManagerConnection().
                                           getContainerStateByLogicalName(fullName));

                    plugin = (IPlugin)factory.createPlugin(getPluginContext(),
                                                           metaName,
                                                           pVersion,
                                                           metaAttributes);
                }
            }
            else if (isFolder)
            {
                plugin = new RuntimeFolderPlugin(getPluginContext(), metaName, metaAttributes);
            }
        }
        catch (Exception e)
        {
            MgmtConsole.getMgmtConsole().notifyMessage(MgmtConsole.MESSAGE_ERROR,
                "RuntimeFolderPlugin::createChildPlugin failed", e, false);
        }
        return plugin;
    }

    @Override
    protected IContentPane createReadablePluginContentPane()
    {
       return new RuntimeFolderContentPane(this);
    }

    @Override
    protected boolean isReadDeniable() {
        return true;
    }

    @Override
    public JPropSheetDialog getPropSheetDialog()
    {
        return new FileFolderDialog(MgmtConsole.getMgmtConsole(), getPluginName());
    }

    @Override
    public Object getModel()
    {
        if (m_model == null)
        {
            m_model = new FileFolderPluginModel(this);
        }

        return m_model;
    }
}
