/**
 * Copyright (c) 2002 Sonic Software Corporation. All Rights Reserved.
 *
 * This software is the confidential and proprietary information of Sonic
 * Software Corpoation. (Confidential Information).  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sonic.
 *
 * SONIC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SONIC SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 *
 * CopyrightVersion 1.0
 */
package com.sonicsw.ma.gui.runtime;

import com.sonicsw.ma.plugin.DefaultPluginFilter;
import com.sonicsw.ma.plugin.IRuntimePlugin;
import com.sonicsw.ma.plugin.PluginAttributes;
import com.sonicsw.mx.config.ConfigServerUtility;

public class RuntimePluginFilter extends DefaultPluginFilter
{
    @Override
    public boolean isPluginVisible(Object destination, Object nodeData)
    {
        boolean res = super.isPluginVisible(destination, nodeData);

        if (res && (nodeData instanceof IRuntimePlugin))
        {
            PluginAttributes attribs = ((IRuntimePlugin)nodeData).getAttributes();

            String type = (String)attribs.get(ConfigServerUtility.TEMPLATE_TYPE);

            if(type != null && type.equalsIgnoreCase(ConfigServerUtility.TEMPLATE_TYPE_PROTOTYPE))
            {
                res = false;
            }
        }
        return res;
    }
}
