/**
 * Copyright (c) 2002 Sonic Software Corporation. All Rights Reserved.
 *
 * This software is the confidential and proprietary information of Sonic
 * Software Corpoation. (Confidential Information).  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sonic.
 *
 * SONIC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SONIC SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 *
 * CopyrightVersion 1.0
 */
package com.sonicsw.ma.gui.runtime;

import java.awt.Color;

import javax.swing.Icon;
import javax.swing.JLabel;

import com.sonicsw.ma.gui.util.ColorIcon;
import com.sonicsw.ma.gui.util.ExtendedImageIcon;
import com.sonicsw.ma.gui.util.ResourceManager;
import com.sonicsw.ma.gui.util.StateHelper;
import com.sonicsw.ma.plugin.AbstractGUIPlugin;
import com.sonicsw.ma.plugin.AbstractPluginTreeCellRenderer;
import com.sonicsw.ma.plugin.PluginAttributes;

public class RuntimePluginTreeCellRenderer
    extends AbstractPluginTreeCellRenderer
{
    @Override
    public void updateRenderer(JLabel label, AbstractGUIPlugin plugin)
    {
        PluginAttributes attributes = plugin.getAttributes();

        Icon icon = null;

        if (attributes.getType() != null)
        {
            icon = ResourceManager.getTypeIcon(plugin.getClass(), attributes.getType());

            if (attributes.isRuntimeRoot() || attributes.isStateable())
            {
                Color backgroundColor = Color.blue;

                if (attributes.getState() != null)
                {
                    backgroundColor = StateHelper.componentStateToColor(attributes.getState());
                }

                icon = new ExtendedImageIcon(new ColorIcon(backgroundColor), icon);
            }
            label.setIcon(icon);
        }

        label.setText(plugin.getPluginName());
    }
}