/**
 * Copyright (c) 2002 Sonic Software Corporation. All Rights Reserved.
 *
 * This software is the confidential and proprietary information of Sonic
 * Software Corpoation. (Confidential Information).  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sonic.
 *
 * SONIC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SONIC SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 *
 * CopyrightVersion 1.0
 */

package com.sonicsw.ma.gui.runtime;

import java.awt.Component;

import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JTable;

import com.sonicsw.ma.gui.table.ModelListTableModel;
import com.sonicsw.ma.gui.util.ColorIcon;
import com.sonicsw.ma.gui.util.ExtendedJTable;
import com.sonicsw.ma.gui.util.StateHelper;
import com.sonicsw.ma.plugin.IPlugin;
import com.sonicsw.ma.plugin.PluginAttributes;

import com.sonicsw.mf.common.runtime.IState;

public class RuntimeStateTableCellRenderer extends ExtendedJTable.ExtendedTableCellRenderer
{
    @Override
    public Component getTableCellRendererComponent(JTable  table,
                                                   Object  value,
                                                   boolean isSelected,
                                                   boolean hasFocus,
                                                   int     row,
                                                   int     column)
    {
        JLabel result = (JLabel)super.getTableCellRendererComponent(table,value,
                                                isSelected,hasFocus,row,column);

        Icon icon   = null;
        String text = null;
        Object rowModel = ((ModelListTableModel)table.getModel()).getRowModel(row);

        if(rowModel instanceof IPlugin)
        {
            IPlugin plugin = (IPlugin)rowModel;
            PluginAttributes attributes = plugin.getAttributes();
            IState state = attributes.getState();

            if (state == null)
            {
                if (!(plugin instanceof RuntimeFolderPlugin))
                {
                    text = "Unknown";
                }
            }
            else
            {
                text = state.getStateString();
            }

            if ((state != null) ||
                ((state == null) && !(plugin instanceof RuntimeFolderPlugin)))
            {
                icon = new ColorIcon(StateHelper.componentStateToColor(state));
            }
        }
        else if(rowModel instanceof IState)
        {
            IState state = (IState)rowModel;

            if(state != null)
            {
                text = state.getStateString();
                icon = new ColorIcon(StateHelper.componentStateToColor(state));
            }
        }

        result.setText((text == null) ? "" : text);
        result.setIcon(icon);

        return result;
    }
}
