/**
 * Copyright (c) 2002 Sonic Software Corporation. All Rights Reserved.
 *
 * This software is the confidential and proprietary information of Sonic
 * Software Corpoation. (Confidential Information).  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sonic.
 *
 * SONIC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SONIC SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 *
 * CopyrightVersion 1.0
 */

package com.sonicsw.ma.gui.runtime;

import com.sonicsw.ma.plugin.IPlugin;
import com.sonicsw.ma.plugin.IRuntimePlugin;

import com.sonicsw.mf.common.runtime.IChildContainerState;
import com.sonicsw.mf.common.runtime.IComponentState;
import com.sonicsw.mf.common.runtime.IContainerState;
import com.sonicsw.mf.common.runtime.IState;

public class RuntimeStopAction extends RuntimeAction
{
    public RuntimeStopAction(IRuntimePlugin plugin, String name)
    {
        this(plugin, name, null);
    }

    public RuntimeStopAction(IRuntimePlugin plugin, String name, String prompt)
    {
        super(plugin, name, "stop", prompt);
    }

    @Override
    public boolean isEnabled()
    {
        boolean res   = true;
        IState  state = ((IPlugin)m_plugin).getAttributes().getState();

        if (state == null)
        {
            res = false;
        }
        else
        {
            if ((state instanceof IContainerState) &&
                (state.getState() == IContainerState.STATE_OFFLINE))
            {
                res = false;
            }

            if ((state instanceof IChildContainerState) &&
                (state.getState() == IChildContainerState.STATE_OFFLINE))
            {
                res = false;
            }

            if ((state instanceof IComponentState) &&
                (state.getState() == IComponentState.STATE_OFFLINE))
            {
                res = false;
            }
        }

        return res;
    }
}