/*
8 * Copyright (c) 2004 Sonic Software Inc. All Rights Reserved
 *
 * This software is confidential and proprietary information.
 * You shall not disclose such Confidential Information and
 * shall use it only in accordance with the terms of the source code license
 * agreement you entered into with Sonic Software Inc.
 *
 */
package com.sonicsw.ma.gui.runtime;

import java.awt.event.ActionEvent;
import java.beans.PropertyVetoException;

import javax.swing.JInternalFrame;

import com.sonicsw.ma.gui.MgmtConsole;
import com.sonicsw.ma.gui.util.BasicPluginAction;
import com.sonicsw.ma.plugin.IRuntimePlugin;

import com.sonicsw.mf.common.runtime.IContainerState;


/**
 * <p>Title: RuntimeViewLogAction</p>
 * <p>Description: Creates an Action to invoke View Log internal frame </p>
 * @author Chandana Konda
 *
 */
    public class RuntimeViewLogAction extends BasicPluginAction
    {
    	private AbstractRuntimePlugin plugin = null;
    	
    	public RuntimeViewLogAction(AbstractRuntimePlugin plugin)
    	{
    		super(plugin, "runtime.viewlog");
    		this.plugin = plugin;
		}

    
    	/**
    	 * view log action opens a new view log internal frame if there is no view  
    	 * log frame already opened on the selected container
    	 * else selects the already existing view log internal frame.    		
    	 */
    	@Override
        public void actionPerformed(ActionEvent e)
    	{
    		JInternalFrame[] frame = (JInternalFrame [])MgmtConsole.getMgmtConsole().getDesktopPane().getAllFrames();
    		boolean frameFound = false;
    		for (int i = 0; i < frame.length; i++) {
    			if (frame != null && frame[i] instanceof ViewLogInternalFrame)
    			{
    				ViewLogInternalFrame frame1 = (ViewLogInternalFrame)frame[i];
    				if(frame1.getPluginName().equals(plugin.getPluginName()))
    				{
						try { 
							frame1.setSelected(true);
						} catch (PropertyVetoException e1) {
						    MgmtConsole.getMgmtConsole().notifyMessage(MgmtConsole.ERROR, e1.getMessage(), e1, false);    // Log the error msg.
						}
    				frameFound = true;
    				break;
    				}
    			}
    		}
    		if(!frameFound)
            {
                MgmtConsole.getMgmtConsole().showInternalFrame(new ViewLogInternalFrame(plugin), true);
            }
    	}
    	
    	/**
    	 * Method enables or disables view log based on the container state.
    	 * View centralized log is enabled is always  
    	 */
    	@Override
        public boolean isEnabled()
    	{    		
    		if (plugin instanceof IRuntimePlugin && ((IRuntimePlugin)plugin).getPluginContext().getConnectionInfo().isConnected())
            {	            
            	if(getPlugin() instanceof RuntimeDomainFolderPlugin) //for managed objects
                {
            		return true;
    			}
                else
                {
                    return(((IRuntimePlugin)plugin).getAttributes().getState().getState() == IContainerState.STATE_ONLINE);
                }       	                                
            }
            else
            {             
                return false;
            }
    	}
    }
