package com.sonicsw.ma.gui.runtime.metrics;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

import javax.management.ObjectName;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.ToolTipManager;
import javax.swing.table.TableColumn;

import com.sonicsw.ma.gui.JPreferencesDialog;
import com.sonicsw.ma.gui.PreferenceManager;
import com.sonicsw.ma.gui.runtime.metrics.model.AbstractMetricsModel;
import com.sonicsw.ma.gui.runtime.metrics.model.AggregateMetricsModel;
import com.sonicsw.ma.gui.runtime.metrics.model.AggregateValueUpdatedEvent;
import com.sonicsw.ma.gui.runtime.metrics.model.IValueUpdatedEvent;
import com.sonicsw.ma.gui.runtime.util.IWatcher;
import com.sonicsw.ma.gui.table.IModelTableModel;
import com.sonicsw.ma.gui.table.ModelListTableModel;
import com.sonicsw.ma.gui.table.RowTableColumn;
import com.sonicsw.ma.gui.util.ColorIcon;
import com.sonicsw.ma.gui.util.ExtendedJTable;
import com.sonicsw.ma.gui.util.JRowTable;
import com.sonicsw.ma.gui.util.ResourceManager;

import com.sonicsw.mf.common.metrics.IMetricIdentity;
import com.sonicsw.mf.common.runtime.impl.CanonicalName;

/**
 * <p>Title: </p>
 * <p>Description: </p>
 * <p>Copyright: Copyright (c) 2002</p>
 * <p>Company: Sonic Software Corporation </p>
 * @author not attributable
 * @version 1.0
 */

public class AggregateMetricsWatchWindow extends MetricsWatchWindow
{
    /** Textural representations of aggregation type (indexed by IAggregateMetric.<type>). */
    public static final String[] AGGREGATION_TYPE_TEXT =
        new String[] {"Total", "Average", "Maximum", "Minimum"};

    static AggregateMetricsWatchWindow getWatchWindow(ObjectName scopeName)
    {
        CanonicalName cname = new CanonicalName(scopeName.toString());
        String name = cname.getCanonicalName();
        AggregateMetricsWatchWindow window = (AggregateMetricsWatchWindow) m_watchWindows.get(name);

        if (window == null)
        {
            window = new AggregateMetricsWatchWindow(name);
            m_watchWindows.put(name, window);
        }
        return window;
    }

    public AggregateMetricsWatchWindow(String scopeID)
    {
        super(IWatcher.DOMAIN_SCOPE, scopeID);
        prepareObject(scopeID);
    }
    private void prepareObject(String scopeID) {
        
        setTitle(getTitle());
        setFrameIcon(ResourceManager.getIcon(getClass(), "linechart"));
        m_scopeID = scopeID;

        // TODO This code is a potential problem - m_panelMetrics is already setup in the call
        //      to super (constructor) - need to check that the MetricsWatchPanel doesn't
        //      register with listeners, etc. as this might create cleanup / dispose problems.
        getContentPane().add(m_panelMetrics = new AggregateMetricsWatchPanel(getWatchScope()));
    }

    public class AggregateMetricsWatchPanel
        extends MetricsWatchPanel
    {
        public AggregateMetricsWatchPanel(short scope)
        {
            super(scope);
        }

        @Override
        protected MetricsTable createTable(short scope)
        {
            return new AggregateMetricsTable(AggregateMetricsWatchPanel.this, scope);
        }

        @Override
        protected void maInitialize()
        {
            // set initial values from preferences
            PreferenceManager pManager = PreferenceManager.getInstance();

            m_pollFrequency = pManager.getInt(JPreferencesDialog.METRIC_PREFS,
                                              JPreferencesDialog.AGGREGATE_POLL_FREQUENCY,
                                              JPreferencesDialog.DEFAULT_AGGREGATE_POLL_FREQUENCY);
            ToolTipManager.sharedInstance().registerComponent(m_table);
        }

        @Override
        protected void createGui(short scope)
        {
            super.createGui(scope);

            m_chartBar.setElevatedAndRotated(true);
        }

        @Override
        protected void maCleanup()
        {
            // remove value listener subscriptions and cleanup maps
            Iterator i = m_subscriptions.entrySet().iterator();

            while (i.hasNext())
            {
                Map.Entry entry = (Map.Entry) i.next();
                String collectionID = (String) entry.getKey();
                HashMap map = (HashMap) entry.getValue();
                AggregateMetricsModel model = (AggregateMetricsModel) ((Object[]) m_modelMap.get(collectionID))[0];
                Iterator metricIds = map.keySet().iterator();

                while (metricIds.hasNext())
                {
                    model.removeValueListener((IMetricIdentity) metricIds.next(), this);
                }

                map.clear();
            }
            m_subscriptions.clear();
            m_modelMap.clear();

            m_watchWindows.remove(m_scopeID);
            ToolTipManager.sharedInstance().unregisterComponent(m_table);
        }

        //-------------------------------------------------------------------------
        //
        // IMetricWatcher implementation
        //
        //-------------------------------------------------------------------------

        @Override
        public void addWatch(IMetricIdentity metricId, AbstractMetricsModel metricsModel)
        {
            ObjectName componentName = metricsModel.getComponentName();
            String collectionID = ((AggregateMetricsModel) metricsModel).getCollectionConfigID();

            HashMap metricValues = (HashMap) m_subscriptions.get(collectionID);
            if (metricValues == null)
            {
                metricValues = new HashMap();
                m_subscriptions.put(collectionID, metricValues);
            }

            HashMap types = (HashMap) metricValues.get(metricId);

            if (types == null) // new watch
            {
                types = new HashMap(4);
                Object[] modelUsage = (Object[]) m_modelMap.get(collectionID);
                if (modelUsage == null)
                {
                    modelUsage = new Object[]
                                 {metricsModel, new int[]
                                 {0}
                    };
                    m_modelMap.put(collectionID, modelUsage);
                }
                ((int[]) modelUsage[1])[0]++;

                for (int i = 0; i < AGGREGATION_TYPE_TEXT.length; i++)
                {
                    short type = new Integer(i).shortValue();
                    AggregateMetricValue metricValue = new AggregateMetricValue(componentName, collectionID, metricId, type); //[new stuff] for right now use total
                    metricValue.setColorId(m_colors.getNextColor());
                    types.put(AGGREGATION_TYPE_TEXT[i], metricValue);
                    ((IModelTableModel) m_table.getModel()).addRow(metricValue);
                    m_chartLine.add(metricValue);
                    m_chartBar.add(metricValue);
                }

                metricValues.put(metricId, types);
                metricsModel.addValueListener(metricId, this); //one listener for all aggregation types
            }
            else
            {
                if (types.size() == AGGREGATION_TYPE_TEXT.length)
                {
                    return;
                }
                for (int i = 0; i < AGGREGATION_TYPE_TEXT.length; i++)
                {
                    if (!types.containsKey(AGGREGATION_TYPE_TEXT[i])) //only add ones that were removed
                    {
                        short type = new Integer(i).shortValue();
                        AggregateMetricValue metricValue = new AggregateMetricValue(componentName, collectionID, metricId, type); //[new stuff] for right now use total
                        metricValue.setColorId(m_colors.getNextColor());
                        types.put(AGGREGATION_TYPE_TEXT[i], metricValue);
                        ((IModelTableModel) m_table.getModel()).addRow(metricValue);
                        m_chartLine.add(metricValue);
                        m_chartBar.add(metricValue);
                    }
                }
            }
        }

        @Override
        public void valueUpdated(IValueUpdatedEvent vue)
        {
            AggregateValueUpdatedEvent avue = (AggregateValueUpdatedEvent) vue;
            HashMap metricValues = (HashMap) m_subscriptions.get(avue.getCollectionID());

            if (metricValues != null)
            {
                HashMap types = (HashMap) metricValues.get(vue.getMetricId());
                if (types != null)
                {
                    long[] results = avue.getValues();
                    Iterator i = types.keySet().iterator();
                    while (i.hasNext())
                    {
                        AggregateMetricValue metricValue = (AggregateMetricValue) types.get(i.next());
                        int rowIndex = ((IModelTableModel) m_table.getModel()).getIndexOf(metricValue);
                        int typeIndex = metricValue.getAggregationType().intValue();
                        metricValue.setValue(results[typeIndex]);
                        metricValue.setCurrency(avue.getCurrencyTimestamp());
                        metricValue.setSources(avue.getSources());
                        if (rowIndex >= 0)
                        {
                            ((ModelListTableModel) m_table.getModel()).rowChanged(rowIndex);
                        }

                        m_chartLine.update(metricValue);
                        m_chartBar.update();
                    }
                }
            }
        }

        @Override
        public void removeWatch(MetricValue[] metricValue)
        {
            for (int i = 0; i < metricValue.length; i++)
            {
                if (metricValue[i] == null)
                {
                    continue;
                }
                boolean isRemoved = false;

                String collectionID = ((AggregateMetricValue)metricValue[i]).getCollectionID();
                IMetricIdentity metricId = metricValue[i].getMetricIdentity();
                HashMap metricValues = (HashMap) m_subscriptions.get(collectionID);
                String type = ((AggregateMetricValue)metricValue[i]).getAggregationStringType();
                HashMap types = (HashMap) metricValues.get(metricId);
                types.remove(type);

                if (types.isEmpty())
                {
                    metricValues.remove(metricId);
                    isRemoved = true;
                }

                if (metricValues.isEmpty())
                {
                    m_subscriptions.remove(collectionID);
                }

                if (isRemoved) //only if metricID removed from metricValues
                {
                    Object[] modelUsage = (Object[]) m_modelMap.get(collectionID);
                    AggregateMetricsModel metricsModel = (AggregateMetricsModel) modelUsage[0];
                    ((int[]) modelUsage[1])[0]--;
                    if (((int[]) modelUsage[1])[0] == 0)
                    {
                        m_modelMap.remove(collectionID);
                    }

                    metricsModel.removeValueListener(metricId, this);
                }

                m_chartLine.remove(metricValue[i]);
                m_chartBar.remove(metricValue[i]);
                ((IModelTableModel) m_table.getModel()).delete(metricValue[i]);
            }
        }

        @Override
        public void refreshWatch(MetricValue[] metricValue)
        {
            for (int i = 0; i < metricValue.length; i++)
            {
                if (metricValue[i] == null)
                {
                    continue;
                }

                String collectionID = ((AggregateMetricValue)metricValue[i]).getCollectionID();
                IMetricIdentity metricId = metricValue[i].getMetricIdentity();
                Object[] modelUsage = (Object[]) m_modelMap.get(collectionID);
                AggregateMetricsModel metricsModel = (AggregateMetricsModel) modelUsage[0];
                metricsModel.refreshMetricValues(new IMetricIdentity[]
                                                 {metricId});
            }
        }
    }

    public class AggregateMetricsTable
        extends MetricsTable
    {
        public AggregateMetricsTable(AggregateMetricsWatchPanel panelParent, short nScope)
        {
            super(panelParent, nScope);
        }

        @Override
        protected void createGUI(short nScope)
        {
            // only show the source component if this is not a component watcher
            TableColumn[] tableColumns = new TableColumn[]
            {
                 new MetricColumn(0, "Metric", 30),
                 new SourcesColumn(1, "Sources", 10),
                 new TypesColumn(2, "Aggregation Type", 20),
                 new ValueColumn(3, "Value", 20),
                 new CurrencyColumn(4, "Date & Time", 20),
            };

            m_table = new JRowTable(tableColumns, getClass().getName());
            m_table.setSelectionMode(ListSelectionModel.MULTIPLE_INTERVAL_SELECTION);
            m_table.setDefaultRenderer(Object.class, new AggregateMetricsTableCellRenderer());
        }

        private class TypesColumn
            extends RowTableColumn
        {
            TypesColumn(int modelIndex, String name, int width)
            {
                super(modelIndex, name, width);
            }

            @Override
            public Object getColumnValue(Object rowModel)
            {
                return ((AggregateMetricValue) rowModel).getAggregationStringType();
            }
        }

        private class SourcesColumn
            extends RowTableColumn
        {
            SourcesColumn(int modelIndex, String name, int width)
            {
                super(modelIndex, name, width);
            }

            @Override
            public Object getColumnValue(Object rowModel)
            {
                return ((AggregateMetricValue) rowModel).getSourcesCount();
            }
        }

        public class AggregateMetricsTableCellRenderer extends ExtendedJTable.ExtendedTableCellRenderer
        {
            @Override
            public java.awt.Component getTableCellRendererComponent(JTable  table,
                                                           Object  value,
                                                           boolean isSelected,
                                                           boolean hasFocus,
                                                           int     row,
                                                           int     column)
            {
                JLabel result = (JLabel)super.getTableCellRendererComponent(table,value,
                                                        isSelected,hasFocus,row,column);

                if (column == 0)
                {
                    ModelListTableModel model = (ModelListTableModel) ((JRowTable) table).getModel();
                    AggregateMetricValue metricValue = (AggregateMetricValue) model.getRowModel(row);
                    result.setIcon(new ColorIcon(metricValue.getColorId(), 14));
                }
                else
                {
                    result.setIcon(null);
                }

                return result;
            }
        }
    }

    private class AggregateMetricValue
        extends MetricValue
    {
        private String[] m_sources = new String[0];
        private String m_collectionID;
        private short m_type;

        public AggregateMetricValue(ObjectName nameSource, String collectionID, IMetricIdentity metric, short type)
        {
            super(nameSource, metric);
            m_collectionID = collectionID;
            m_type = type;
        }

        @Override
        public String getMetricDescription()
        {
            return super.getMetricDescription() + " (" + getAggregationStringType() + ")";
        }

        public String getCollectionID()
        {
            return m_collectionID;
        }

        private void setSources(String[] sources)
        {
            m_sources = sources;
        }

        private String[] getSources()
        {
            return m_sources;
        }

        private Integer getSourcesCount()
        {
            int count = (m_sources.length == 0) ? 0 : m_sources.length;
            return (new Integer(count));
        }

        private Short getAggregationType()
        {
            return new Short(m_type);
        }

        private String getAggregationStringType()
        {
            return AGGREGATION_TYPE_TEXT[m_type];
        }
    }
}
