/**
 * Copyright (c) 2002 Sonic Software Corporation. All Rights Reserved.
 *
 * This software is the confidential and proprietary information of Sonic
 * Software Corpoation. (Confidential Information).  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sonic.
 *
 * SONIC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SONIC SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 *
 * CopyrightVersion 1.0
 */
package com.sonicsw.ma.gui.runtime.metrics;

import javax.swing.JPanel;
import javax.swing.JTextField;

import modelobjects.framework.EditRule;
import modelobjects.framework.IntToStringConverter;
import modelobjects.framework.model.ModelAspectId;
import modelobjects.framework.model.ModelObjectAdapter;
import modelobjects.framework.model.ModelObjectPropagator;
import modelobjects.framework.model.ModelObjectValidator;
import modelobjects.framework.model.ModelPropagationException;
import modelobjects.framework.model.ModelValidationException;
import modelobjects.framework.swing.JTextFieldAdapter;

import com.sonicsw.ma.gui.propsheets.JPropSheetDialog;
import com.sonicsw.ma.gui.runtime.metrics.model.IMetricWatcher;
import com.sonicsw.ma.gui.util.JMAFrame;
import com.sonicsw.ma.gui.util.JPartitionPanel;

class JMetricsWatchOptionsDialog extends JPropSheetDialog
{
    private JTextField m_poll;


    public JMetricsWatchOptionsDialog(JMAFrame parent)
    {
        super(parent, "metrics.watcher.options", JMetricsWatchOptionsDialog.Model.class);

        setValidator(new Validator());
        setPropagator(new Propagator());
    }

    @Override
    public void initUI() throws Exception
    {
        getContentPane().add(JPartitionPanel.wrap(createMainPanel()));
    }

    @Override
    public void initForm() throws Exception
    {
        new JTextFieldAdapter(ModelAspectId.forName("pollFrequency"), m_poll, EditRule.NEVER,
                              new IntToStringConverter(false), getMediator());
    }

    private JPanel createMainPanel()
    {
        m_poll = new JTextField(5);

        JPartitionPanel panel = new JPartitionPanel(false, "Watch Data");
        panel.addRow("Poll Frequency", m_poll, "seconds");

        return panel;
    }

    //-------------------------------------------------------------------------

    public class Model
    {
        private int poll;

        IMetricWatcher watcher;

        public Model(IMetricWatcher watcher)
        {
            this.watcher = watcher;
            this.poll    = watcher.getPollFrequency();
        }

        public int getPollFrequency() { return this.poll; }
        public void setPollFrequency(int poll) { this.poll = poll; }
    }

    private static class Validator
    implements ModelObjectValidator
    {
        @Override
        public void validateModelEdit(ModelObjectAdapter adapter)
        throws ModelValidationException
        {
            JMetricsWatchOptionsDialog.Model model = (JMetricsWatchOptionsDialog.Model)adapter.getModelObject();

            if (model.getPollFrequency() < 10)
            {
                throw new ModelValidationException("The poll frequency must be >= 10 seconds");
            }
            if (model.getPollFrequency() > 900)
            {
                throw new ModelValidationException("The poll frequency must be <= 900 seconds");
            }
        }

        @Override
        public void validateModelCreation(ModelObjectAdapter adapter)
        throws ModelValidationException { }

        @Override
        public void validateModelDeletion(ModelObjectAdapter adapter)
        throws ModelValidationException { }
    }

    private static class Propagator
    implements ModelObjectPropagator
    {
        @Override
        public void propagateModelEdit(ModelObjectAdapter adapter)
        throws ModelPropagationException
        {
            JMetricsWatchOptionsDialog.Model model = (JMetricsWatchOptionsDialog.Model)adapter.getModelObject();

            model.watcher.setPollFrequency(model.getPollFrequency());
        }

        @Override
        public void propagateModelCreation(ModelObjectAdapter modelObjectAdapter)
        throws ModelPropagationException { }

        @Override
        public void propagateModelDeletion(ModelObjectAdapter modelObjectAdapter)
        throws ModelPropagationException { }
    }
}
