package com.sonicsw.ma.gui.runtime.metrics;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;

import lt.monarch.chart.AbstractChartPlugin;
import lt.monarch.chart.ChartEntity;
import lt.monarch.chart.HotSpotMap;
import lt.monarch.chart.chart2D.ConnectedSeries;
import lt.monarch.chart.chart2D.ScatterSeries;
import lt.monarch.chart.marker.DotMarker;

public class MarkerSelector extends AbstractChartPlugin
    implements MouseMotionListener
{
    ////////////////////////////////////////////////////////////////////////////////////////////////
    // Attributes
    //

    private ScatterSeries.MarkerEntity currentEntity;
    private DotMarker marker;

    ////////////////////////////////////////////////////////////////////////////////////////////////
    // Public Methods
    //

    public MarkerSelector ()
    {
        marker = new DotMarker ();
        marker.setDotSize (10);
        marker.setFillColor (Color.red);
    }

    @Override
    public void activate ()
    {
        chart().container().addMouseMotionListener (this);
    }

    @Override
    public void deactivate ()
    {
        chart().container().removeMouseMotionListener (this);
    }

    @Override
    public void mouseDragged (MouseEvent e)
    {
        if (currentEntity != null)
        {
            Rectangle r = marker.getBounds ();
            currentEntity = null;
            chart().repaint (r);
        }
    }

    @Override
    public void mouseMoved (MouseEvent e)
    {
        HotSpotMap map = chart().container().getHotSpotMap ();
        ChartEntity entity = map.findEntityAt (e.getPoint());

        if (currentEntity != null && !currentEntity.equals (entity))
        {
            Rectangle r = marker.getBounds ();
            currentEntity = null;
            chart().repaint (r);
        }

        if (entity instanceof ConnectedSeries.MarkerEntity && !entity.equals (currentEntity))
        {
            e.consume ();
            currentEntity = (ConnectedSeries.MarkerEntity)entity;

            Graphics g = chart().container().getUpdateGraphics ();
            marker.setLocation (chart().projector(), currentEntity.getPosition ());
            marker.prepare (g);
            Rectangle r = marker.getBounds ();
            g.dispose ();
            chart().repaint (r);
        }
    }

    @Override
    public void paint (Graphics g)
    {
        if (currentEntity != null)
        {
            marker.draw (g);
        }
    }
}
