package com.sonicsw.ma.gui.runtime.metrics;

import java.awt.Color;

import javax.management.ObjectName;

import com.sonicsw.mf.common.metrics.IMetricIdentity;

/**
 * <p>Title: </p>
 * <p>Description: </p>
 * <p>Copyright: Copyright (c) 2002</p>
 * <p>Company: Sonic Software Corporation </p>
 * @author not attributable
 * @version 1.0
 */

public class MetricValue
{
    protected ObjectName m_source;
    protected IMetricIdentity m_metric;
    protected long m_value;
    protected long m_currency;
    protected Color m_colorId = Color.BLACK;

    public MetricValue(ObjectName source, IMetricIdentity metric)
    {
        this(metric);
        m_source = source;
    }

    public MetricValue(IMetricIdentity metric)
    {
        m_metric = metric;
    }

    public String getSource()
    {
        return m_source.toString();
    }

    public Color getColorId()
    {
        return m_colorId;
    }

    public void setColorId(Color colorId)
    {
        m_colorId = colorId;
    }

    public ObjectName getSourceName()
    {
        return m_source;
    }

    public String getMetric()
    {
        return m_metric.toString();
    }

    public String getMetricDescription()
    {
        return getMetric();
    }

    public IMetricIdentity getMetricIdentity()
    {
        return m_metric;
    }

    public Long getValue()
    {
        return new Long(m_value);
    }

    public void setValue(long value)
    {
        m_value = value;
    }

    public Long getCurrency()
    {
        return new Long(m_currency);
    }

    public void setCurrency(long currency)
    {
        m_currency = currency;
    }

    public String toDebug()
    {
        StringBuffer sb = new StringBuffer();

        sb.append("Metric: ").append(getMetric()).append(", ");
        sb.append("Value: ").append(getValue()).append(", ");
        sb.append("Timestamp: ").append(getCurrency());

        return sb.toString();
    }
}