package com.sonicsw.ma.gui.runtime.metrics;

import java.awt.Color;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

import lt.monarch.chart.AbstractChartDataModel;
import lt.monarch.chart.AxisMapper;
import lt.monarch.chart.ChartDataModel2D;
import lt.monarch.chart.ChartDataModelAnnotations;
import lt.monarch.chart.chart2D.Axis2D;
import lt.monarch.chart.chart3D.BarSeries3D;
import lt.monarch.chart.mapper.MathAxisMapper;

import com.sonicsw.ma.gui.util.Helper;

public class MetricsBarSeries
{
    private BarSeries3D m_series = null;
    private AxisMapper m_yMapper = null;
    private MetricsSeriesModel m_model = null;
    private MetricValue m_value = null;

    ////////////////////////////////////////////////////////////////////////////
    // Public Methods
    //

    public MetricsBarSeries(MetricValue value, Axis2D xAxis, Axis2D yAxis,
                            AxisMapper yMapper, Color color)
    {
        super();

        m_value = value;
        m_yMapper = yMapper;

        // create the series for this item...
        m_series = new BarSeries3D(
            m_model = new MetricsSeriesModel(), xAxis, yAxis);

        m_series.setFillColor(color);
        m_series.setName(getName());
    }

    final public BarSeries3D getSeries() { return m_series; }
    public final String getName() { return m_value.getMetric(); }
    public MetricValue getMetric() { return m_value; }

    public void update()
    {
        m_model.refresh();
    }

    public void close()
    {
        m_model.close();
        m_model = null;

        m_series.cleanup();
        m_series = null;
    }

    ////////////////////////////////////////////////////////////////////////////////////////////////
    // Inner Classes
    //

    private class MetricsSeriesModel
        extends AbstractChartDataModel
        implements ChartDataModel2D, ChartDataModelAnnotations
    {
        private SimpleDateFormat m_dateFormatter = new SimpleDateFormat("h:mm:ss a");

        private NumberFormat m_formatter = NumberFormat.getInstance();
        private List m_dataY = Collections.synchronizedList(new ArrayList());

        public MetricsSeriesModel()
        {
            super();

            m_dataY.add(0, new Integer(0));
        }

        public void close()
        {
            m_dateFormatter = null;

            m_dataY.clear();
            m_dataY = null;
        }

        @Override
        public int getValueCount()
        {
            return 1;
        }

        @Override
        public Object getYValueAt(int pos)
        {
            Object objValue = null;

            if (m_dataY != null)
            {
                objValue = m_dataY.get(pos);
            }

            return objValue;
        }

        @Override
        public Object getXValueAt(int pos)
        {
            return m_value.getMetric();
        }

        @Override
        public String getDescriptionAt(int pos)
        {
            StringBuffer sb = new StringBuffer();

            sb.append("Metric: " + m_value.getMetricDescription() + "\r\n");
            sb.append("Time: " + m_dateFormatter.format(m_value.getCurrency()) + "\r\n");
            sb.append("Value: " + m_formatter.format(getYValueAt(pos)));

            return sb.toString();
        }

        @Override
        public String getLabelAt(int pos)
        {
            return null;
        }

        public void refresh()
        {
            // All chart related activities have to be carried on the GUI thread.
            Helper.invoke(new Runnable ()
            {
                @Override
                public void run()
                {
                    m_dataY.add(0, m_value.getValue());

                    updateRanges();
                    fireModelChanged();
                }
            });
        }

        public void updateRanges()
        {
            Object obj = m_value.getValue();

            if (obj instanceof Number)
            {
                double dMin = ((Number)obj).doubleValue();
                double dMax = ((Number)obj).doubleValue();

                // This approach will only expand the range as needed.
                // It will never shrink the range
                Number numValue = (Number)obj;

                if (numValue != null)
                {
                    double dValue = numValue.doubleValue();

                    if (dMin > dValue)
                    {
                        dMin = dValue;
                    }
                    if (dMax < dValue)
                    {
                        dMax = dValue;
                    }
                }

                ((MathAxisMapper)m_yMapper).updateRange(dMax);
                ((MathAxisMapper)m_yMapper).updateRange(dMin);
            }
        }
    }
}