package com.sonicsw.ma.gui.runtime.metrics;

import lt.monarch.chart.Chart;
import lt.monarch.chart.SimpleHotSpotMap;
import lt.monarch.chart.swing.JChartPanel;
import lt.monarch.chart.view.LabeledChart;

public class MetricsChart extends JChartPanel
{
    ////////////////////////////////////////////////////////////////////////////
    // Attributes
    //

    private LabeledChart          m_topChart          = null;
    private Chart                 m_viewChart         = null;
    private String                m_strName           = null;
    private String                m_strDescription    = null;
    private boolean               m_bInitialized      = false;
    private SimpleHotSpotMap      m_hotSpot           = null;

    ////////////////////////////////////////////////////////////////////////////
    // Methods
    //

    public MetricsChart (Chart viewChart)
    {
        super (new LabeledChart (viewChart));

        m_topChart = (LabeledChart)super.chart;
        m_viewChart = viewChart;
    }

    public void init()
    {
        if (m_bInitialized == false)
        {
            if (m_strName != null)
            {
                m_topChart.setTitle(m_strName);
            }

            // We have to explicitly assign a hot spot map if we want
            // the tooltip plugin to work correctly. The default hot
            // spot map does not gather any hot spot information
            setHotSpotMap (m_hotSpot = new SimpleHotSpotMap ());

            m_bInitialized = true;
        }
    }

    final public Chart getViewChart()
    {
        return m_viewChart;
    }

    public void update()
    {
        // intentionally ignored...
    }

    public void close()
    {
        removeAll();
        m_hotSpot = null;
        m_viewChart.cleanup();
    }

    public void onChanged()
    {
        // reflect any changes...
        m_topChart.setTitle (m_strName);
        m_topChart.invalidate();
    }

    @Override
    final public void setName(String strName)                 { m_strName = strName; }
    @Override
    final public String getName()                             { return m_strName; }
    final public void setDescription(String strDescription)   { m_strDescription = strDescription; }
    final public String getDescription()                      { return m_strDescription; }
}
