package com.sonicsw.ma.gui.runtime.metrics;

import java.awt.BorderLayout;
import java.awt.event.ActionEvent;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collection;

import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;

import com.sonicsw.ma.gui.IApplication;
import com.sonicsw.ma.gui.MgmtConsole;
import com.sonicsw.ma.gui.runtime.util.IWatcher;
import com.sonicsw.ma.gui.table.IModelTableModel;
import com.sonicsw.ma.gui.table.ModelListTableModel;
import com.sonicsw.ma.gui.table.RowTableColumn;
import com.sonicsw.ma.gui.util.BasicAction;
import com.sonicsw.ma.gui.util.BasicGuiAction;
import com.sonicsw.ma.gui.util.ColorIcon;
import com.sonicsw.ma.gui.util.EditableTablePanel;
import com.sonicsw.ma.gui.util.ExtendedJTable;
import com.sonicsw.ma.gui.util.Helper;
import com.sonicsw.ma.gui.util.JMAFrame;
import com.sonicsw.ma.gui.util.JRowTable;
import com.sonicsw.ma.gui.util.ResourceManager;

/**
 * <p>Title: </p>
 * <p>Description: </p>
 * <p>Copyright: Copyright (c) 2002</p>
 * <p>Company: Sonic Software Corporation </p>
 * @author not attributable
 * @version 1.0
 */

public class MetricsTable
    extends EditableTablePanel
{
    protected MetricsWatchPanel m_panelParent = null;
    protected JRowTable m_table = null;
    protected JButton m_btnOptions = null;
    protected JButton m_btnRefresh = null;
    protected short m_nScope = -1;
    private NumberFormat m_formatter = NumberFormat.getInstance();

    public MetricsTable(MetricsWatchPanel panelParent, short nScope)
    {
        super(false, false, true);
        prepareMetricsTable(panelParent, nScope);
    }
    
    private void prepareMetricsTable(MetricsWatchPanel panelParent, short nScope) {
        
        m_panelParent = panelParent;
        createGUI(m_nScope = nScope);

        setComponent(m_table);
        m_table.getSelectionModel().addListSelectionListener(new ListSelectionListener()
        {
            @Override
            public void valueChanged(ListSelectionEvent e)
            {
                setUIState();
            }
        });

        setObjectIcon(ResourceManager.getIcon(getClass(), "Metric"));

        init();

        m_btnOptions = addButton(new OptionsAction(), BorderLayout.EAST, ICONS_ONLY);
        m_btnOptions.setToolTipText("Options");
        if (MgmtConsole.DEVELOPER_MODE)
        {
            m_btnRefresh = addButton(new RefreshWatchAction(), BorderLayout.EAST, ICONS_ONLY);
            m_btnRefresh.setToolTipText("Refresh");
        }
        getRemoveButton().setToolTipText("Remove");
        setBorder(new EmptyBorder(5, 5, 5, 0));
        setUIState();
    }

    public void init()
    {
        super.init(BorderLayout.EAST, ICONS_ONLY);

        setUIState();
    }

    @Override
    public void setUIState()
    {
        super.setUIState();

        if (m_btnOptions != null)
        {
            m_btnOptions.setEnabled(((BasicAction) m_btnOptions.getAction()).isEnabled());
        }

        if (m_btnRefresh != null)
        {
            m_btnRefresh.setEnabled(((BasicAction) m_btnRefresh.getAction()).isEnabled());
        }
    }

    @Override
    protected void onRemove()
    {
        Collection colValues = getSelectedRowValues();
        MetricValue[] values = (MetricValue[]) colValues.toArray(new MetricValue[colValues.size()]);

        m_panelParent.removeWatch(values);
    }

    protected void onRefresh()
    {
        Collection colValues = getSelectedRowValues();
        MetricValue[] values = (MetricValue[]) colValues.toArray(new MetricValue[colValues.size()]);

        m_panelParent.refreshWatch(values);
    }

    protected void onOptions()
    {
        try
        {
            JMAFrame parent = (JMAFrame) SwingUtilities.getAncestorOfClass(JMAFrame.class, m_panelParent);
            JMetricsWatchOptionsDialog dialog = new JMetricsWatchOptionsDialog(parent);
            dialog.editInstance(null, dialog.new Model(m_panelParent), false);
            dialog.setVisible(true);
        }
        catch (Exception e)
        {
            MgmtConsole.getMgmtConsole().notifyMessage(IApplication.MESSAGE_WARNING,
                "Failed to edit metrics watch properties", e, true);
        }
    }

    public JRowTable getTable() { return m_table; }

    public int getMetricCount()
    {
        return m_table.getRowCount();
    }

    public TableModel getModel() { return m_table.getModel(); }

    public void maCleanup()
    {
        if (m_table != null)
        {
            m_table.cleanup();
        }
    }

    protected void createGUI(short nScope)
    {
        // only show the source component if this is not a component watcher
        TableColumn[] tableColumns = null;

        if (nScope == IWatcher.COMPONENT_SCOPE)
        {
            tableColumns = new TableColumn[]
            {
                           new MetricColumn(0, "Metric", 40),
                           new ValueColumn(1, "Value", 30),
                           new CurrencyColumn(2, "Date & Time", 30),
            };
        }
        else
        {
            tableColumns = new TableColumn[]
            {
                           new SourceColumn(0, "Source", 30),
                           new MetricColumn(1, "Metric", 30),
                           new ValueColumn(2, "Value", 20),
                           new CurrencyColumn(3, "Date & Time", 20),
            };
        }

        m_table = new JRowTable(tableColumns, getClass().getName());
        m_table.setSelectionMode(ListSelectionModel.MULTIPLE_INTERVAL_SELECTION);
        m_table.setDefaultRenderer(Object.class, new MetricsTableCellRenderer());
    }

    public Collection getSelectedRowValues()
    {
        ArrayList list = new ArrayList();

        int[] sel = m_table.getSelectedRows();

        for (int i = 0; ((sel != null) && (i < sel.length)); i++)
        {
            list.add(((IModelTableModel) m_table.getModel()).getRowModel(sel[i]));
        }

        return list;
    }

    protected class SourceColumn
        extends RowTableColumn
    {
        SourceColumn(int modelIndex, String name, int width)
        {
            super(modelIndex, name, width);
        }

        @Override
        public Object getColumnValue(Object rowModel)
        {
            return ((MetricValue) rowModel).getSource();
        }
    }

    protected class MetricColumn
        extends RowTableColumn
    {
        MetricColumn(int modelIndex, String name, int width)
        {
            super(modelIndex, name, width);
        }

        @Override
        public Object getColumnValue(Object rowModel)
        {
            return ((MetricValue) rowModel).getMetric();
        }
    }

    protected class ValueColumn
        extends RowTableColumn
    {
        ValueColumn(int modelIndex, String name, int width)
        {
            super(modelIndex, name, width);

            setColumnClass(Long.class);
        }

        @Override
        public Object getColumnValue(Object rowModel)
        {
            Object objValue = ((MetricValue) rowModel).getValue();

            if (objValue instanceof Number)
            {
                // format it...
                objValue = m_formatter.format(objValue);
            }

            return objValue;
        }
    }

    protected class CurrencyColumn
        extends RowTableColumn
    {
        CurrencyColumn(int modelIndex, String name, int width)
        {
            super(modelIndex, name, width);

            setColumnClass(Long.class);
            setColumnCellRenderer();
        }

        private void setColumnCellRenderer() {
            setCellRenderer(Helper.getDateTimeTableCellRenderer());
        }
        
        @Override
        public Object getColumnValue(Object rowModel)
        {
            return ((MetricValue) rowModel).getCurrency();
        }
    }

    public class RefreshWatchAction
        extends BasicGuiAction
    {
        public RefreshWatchAction()
        {
            super("MetricsWatchWindow.refresh");
        }

        @Override
        public void actionPerformed(ActionEvent evt)
        {
            onRefresh();
        }
    }

    public class OptionsAction
        extends BasicGuiAction
    {
        public OptionsAction()
        {
            super("MetricsWatchWindow.options");
        }

        @Override
        public void actionPerformed(ActionEvent evt)
        {
            onOptions();
        }
    }

    public class MetricsTableCellRenderer extends ExtendedJTable.ExtendedTableCellRenderer
    {
        @Override
        public java.awt.Component getTableCellRendererComponent(JTable  table,
                                                       Object  value,
                                                       boolean isSelected,
                                                       boolean hasFocus,
                                                       int     row,
                                                       int     column)
        {
            JLabel result = (JLabel)super.getTableCellRendererComponent(table,value,
                                                    isSelected,hasFocus,row,column);

            if (m_nScope == IWatcher.COMPONENT_SCOPE && column == 0 ||
                m_nScope != IWatcher.COMPONENT_SCOPE && column == 1)
            {
                ModelListTableModel model = (ModelListTableModel) ((JRowTable) table).getModel();
                MetricValue metricValue = (MetricValue) model.getRowModel(row);
                result.setIcon(new ColorIcon(metricValue.getColorId(), 14));
            }
            else
            {
                result.setIcon(null);
            }

            return result;
        }
    }
}