package com.sonicsw.ma.gui.runtime.metrics;

import java.awt.Component;
import java.awt.FlowLayout;
import java.util.HashSet;

import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeModel;

import com.sonicsw.ma.gui.runtime.metrics.model.AlertsModel;
import com.sonicsw.ma.gui.runtime.metrics.model.IAlertsProvider;
import com.sonicsw.ma.gui.runtime.metrics.model.InstanceNode;
import com.sonicsw.ma.gui.runtime.metrics.model.InstanceParentNode;
import com.sonicsw.ma.gui.runtime.metrics.model.MetricsModel;
import com.sonicsw.ma.gui.runtime.metrics.model.Node;
import com.sonicsw.ma.gui.runtime.util.AbstractNode;
import com.sonicsw.ma.gui.runtime.util.AbstractParentNode;
import com.sonicsw.ma.gui.util.ExtendedImageIcon;
import com.sonicsw.ma.gui.util.Helper;
import com.sonicsw.ma.gui.util.ResourceManager;

import com.sonicsw.mf.common.metrics.IMetricIdentity;
import com.sonicsw.mf.common.metrics.IMetricInfo;

public final class MetricsTreeCellRenderer extends DefaultTreeCellRenderer
{
    private static volatile Icon[] ICON_METRIC = null;
    private static volatile Icon[] ICON_ALERT  = null;
    private static volatile Icon[] ICON_PARENT = null;
    private static final Icon GREENPLUS_ICON = ResourceManager.getIcon(MetricsTreeCellRenderer.class, "GreenPlus");
    private static final Icon AMBERPLUS_ICON = ResourceManager.getIcon(MetricsTreeCellRenderer.class, "AmberPlus");
    private static final Icon WATCH_ICON = ResourceManager.getIcon(MetricsTreeCellRenderer.class, "watchoverlay");

    private static Object ALERT_LOCK_OBJ = new Object();
    private static Object METRIC_LOCK_OBJ = new Object();
    private static Object PARENT_LOCK_OBJ = new Object();
    private static final Icon getMetricIcon(boolean isEnabled)
    {
        if (ICON_METRIC == null)
        {
        	synchronized (METRIC_LOCK_OBJ) {
                if (ICON_METRIC == null)
                {
                    ICON_METRIC = new Icon[2];
                    ICON_METRIC[0] = ResourceManager.getIcon(MetricsTreeCellRenderer.class, "Metric");
                    ICON_METRIC[1] = Helper.createDisabledIcon(ICON_METRIC[0], 30);
                }
			}
        }

        return isEnabled ? ICON_METRIC[0] : ICON_METRIC[1];
    }

    private static final Icon getAlertIcon(boolean isEnabled)
    {
        if (ICON_ALERT == null)
        {
        	synchronized (ALERT_LOCK_OBJ) {
                if (ICON_ALERT == null)
                {
                    ICON_ALERT = new Icon[2];
                    ICON_ALERT[0] = ResourceManager.getIcon(MetricsTreeCellRenderer.class, "alarm");
                    ICON_ALERT[1] = Helper.createDisabledIcon(ICON_ALERT[0], 30);
                }
			}
        }

        return isEnabled ? ICON_ALERT[0] : ICON_ALERT[1];
    }

    private static final Icon getInstanceParentIcon(boolean isEnabled)
    {
        if (ICON_PARENT == null)
        {
        	synchronized (PARENT_LOCK_OBJ) {
                if (ICON_PARENT == null)
                {
                    ICON_PARENT = new Icon[2];
                    ICON_PARENT[0] = ResourceManager.getIcon(MetricsTreeCellRenderer.class, "InstanceParent");
                    ICON_PARENT[1] = Helper.createDisabledIcon(ICON_PARENT[0], 30);
                }
			}
        }

        return isEnabled ? ICON_PARENT[0] : ICON_PARENT[1];
    }


    // package only access
    public MetricsTreeCellRenderer()
    {
    }

    @Override
    public Component getTreeCellRendererComponent(JTree   tree,
                                                  Object  node,
                                                  boolean selected,
                                                  boolean expanded,
                                                  boolean leaf,
                                                  int     row,
                                                  boolean hasFocus)
    {
        super.getTreeCellRendererComponent(tree, node, selected, expanded, leaf, row, hasFocus);

        boolean isEnabled = ((AbstractNode)node).isEnabled();
        boolean isWatched = false;

        TreeModel model = tree.getModel();
        if(model instanceof MetricsModel)
        {
            Object userObject = ((AbstractNode)node).getUserObject();

            if(userObject != null)
            {
                if(userObject instanceof IMetricIdentity)
                {
                    isWatched = ((MetricsModel)model).hasValueListeners((IMetricIdentity)userObject);
                }
                else if(userObject instanceof IMetricInfo)
                {
                    isWatched = ((MetricsModel)model).hasValueListeners(((IMetricInfo)userObject).getMetricIdentity());
                }
            }
        }

        if ((node instanceof Node) || (node instanceof InstanceNode))
        {
            ExtendedImageIcon iconMetric = new ExtendedImageIcon(getMetricIcon(isEnabled));
            if (isWatched)
            {
                iconMetric.addOverlay(WATCH_ICON);
            }
            setIcon(iconMetric);
        }
        else
        if (node instanceof InstanceParentNode)
        {
            setIcon(getInstanceParentIcon(isEnabled));
        }

        JPanel panel = new JPanel(new FlowLayout(FlowLayout.LEFT, 0, 0));
        panel.setBackground(getBackground());
        panel.add(this);

        if (node instanceof IAlertsProvider)
        {
            AlertsModel alertsModel = ((IAlertsProvider)node).getAlertsModel();
            if (alertsModel != null)
            {
                HashSet alerts = alertsModel.getAlerts();                
                panel.add(new JLabel( getAlertIcon(alerts != null && !alerts.isEmpty())));
            }
        }

        // if its not enabled are any of the children
        if (isEnabled)
        {
            if (node instanceof AbstractParentNode)
            {
                panel.add(new JLabel(GREENPLUS_ICON));
            }
        }
        else
        {
            if (node instanceof AbstractParentNode && ((AbstractParentNode)node).isAncestorEnabled())
            {
                panel.add(new JLabel(AMBERPLUS_ICON));
            }
        }

        return panel;
    }
}