package com.sonicsw.ma.gui.runtime.metrics;

import java.util.HashMap;

import javax.management.ObjectName;
import javax.swing.JComponent;
import javax.swing.JOptionPane;

import com.sonicsw.ma.gui.IWorkspaceWindow;
import com.sonicsw.ma.gui.WorkspaceWindow;
import com.sonicsw.ma.gui.runtime.metrics.model.AbstractMetricsModel;
import com.sonicsw.ma.gui.runtime.metrics.model.IMetricWatcher;
import com.sonicsw.ma.gui.runtime.metrics.model.IValueUpdatedEvent;
import com.sonicsw.ma.gui.util.JMAInternalFrame;
import com.sonicsw.ma.gui.util.ResourceManager;

import com.sonicsw.mf.common.metrics.IMetricIdentity;
import com.sonicsw.mf.common.runtime.impl.CanonicalName;

class MetricsWatchWindow
    extends JMAInternalFrame
    implements IMetricWatcher, IWorkspaceWindow
{
    protected String            m_scopeID      = "";
    protected MetricsWatchPanel m_panelMetrics = null;
    protected WorkspaceWindow   m_domainParent = null;

    protected static final HashMap m_watchWindows = new HashMap();
    static MetricsWatchWindow getWatchWindow(short scope, ObjectName scopeName)
    {
        String name = null;

        // first determine the name to use based on the scope
        CanonicalName cName = new CanonicalName(scopeName.toString());

        switch (scope)
        {
            case DOMAIN_SCOPE:
                name = cName.getDomainName();
                break;
            case CONTAINER_SCOPE:
                name = cName.getDomainName() + "." + cName.getContainerName();
                break;
            case COMPONENT_SCOPE:
            default:
                name = cName.getCanonicalName();
                break;
        }

        MetricsWatchWindow window = (MetricsWatchWindow) m_watchWindows.get(scope + name);

        if (window == null)
        {
            window = new MetricsWatchWindow(scope, name);
            m_watchWindows.put(scope + name, window);
        }
        return window;
    }

    public void setDomainParent(WorkspaceWindow domainParent)
    {
        m_domainParent = domainParent;
    }

    /**
     * Constructor
     */
    protected MetricsWatchWindow(short scope, String scopeID)
    {
        super("metrics.watcher");
        prepareMetricsWatchWindow(scope, scopeID);
    }
    
    private void prepareMetricsWatchWindow(short scope, String scopeID) {
        
        setTitle(getTitle() + " - " + scopeID);
        setFrameIcon(ResourceManager.getIcon(getClass(), "linechart"));

        m_scopeID = scopeID;

        getContentPane().add(m_panelMetrics = new MetricsWatchPanel(scope));
    }

    @Override
    protected void maInitialize()
    {
        m_panelMetrics.maInitialize();
    }

    @Override
    protected void maCleanup()
    {
        // remove dependencies
        if (m_domainParent != null)
        {
            m_domainParent.removeDependantFrame(this);
        }

        // Sonic00027886 (AHJ)
        // There appears to be some possibility that maCleanup gets called more than once
        // in which case m_panelMetrics might already be null - getWatchScope() would
        // then NPE as it tries to reference the m_panelMetrics.
        // This check prevents that from happening...
        if (m_panelMetrics != null)
        {
            m_watchWindows.remove(getWatchScope() + m_scopeID);
            m_panelMetrics.maCleanup();
            m_panelMetrics = null;
        }
    }

    @Override
    public boolean canClose()
    {
        boolean res = true;

        if (m_panelMetrics.getMetricCount() > 0)
        {
            res = (JOptionPane.showConfirmDialog(this,
                                                 "Are you sure you want to close watcher:\n" + m_scopeID,
                                                 "Close Metrics Watcher",
                                                 JOptionPane.YES_NO_OPTION) == JOptionPane.YES_OPTION);
        }

        return res;
    }

    @Override
    public JComponent[] getSelectedMenuItems(int type)
    {
        return m_panelMetrics.getSelectedMenuItems(type);
    }

    //-------------------------------------------------------------------------
    //
    // IMetricWatcher implementation
    //
    //-------------------------------------------------------------------------

    @Override
    public void addWatch(IMetricIdentity metricId,
                         AbstractMetricsModel metricsModel)
    {
        m_panelMetrics.addWatch(metricId, metricsModel);
    }

    @Override
    public void valueUpdated(IValueUpdatedEvent event)
    {
        m_panelMetrics.valueUpdated(event);
    }

    @Override
    public int getPollFrequency()
    {
        return m_panelMetrics.getPollFrequency();
    }

    @Override
    public void setPollFrequency(int pollFrequency)
    {
        m_panelMetrics.setPollFrequency(pollFrequency);
    }

    @Override
    public short getWatchScope()
    {
        return m_panelMetrics.getWatchScope();
    }
}