package com.sonicsw.ma.gui.runtime.metrics.model;

import java.text.CollationKey;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;

import javax.management.ObjectName;
import javax.swing.tree.DefaultTreeModel;

import com.sonicsw.ma.gui.runtime.util.AbstractNode;
import com.sonicsw.mx.util.ICollationKeyProvider;
import com.sonicsw.mx.util.Sorter;

import com.sonicsw.mf.common.metrics.IMetricIdentity;
import com.sonicsw.mf.common.metrics.IMetricInfo;
import com.sonicsw.mf.common.metrics.MetricsFactory;
import com.sonicsw.mf.jmx.client.IRemoteMBeanServer;

public abstract class AbstractMetricsModel extends DefaultTreeModel
implements ICollationKeyProvider
{
    IRemoteMBeanServer m_connector;
    ObjectName m_componentName;
    String m_canonicalName;

    protected ParentNode m_treeRootNode;

    static final String[] METRIC_ID_SIGNATURE  = new String[] { IMetricIdentity.class.getName() };
    static final String[] METRIC_IDS_SIGNATURE = new String[] { IMetricIdentity[].class.getName() };
    static final Object[] SINGLE_NULL_ARG      = new Object[] { null };

    Hashtable m_valueListeners = new Hashtable();

    public AbstractMetricsModel(IRemoteMBeanServer connector, ObjectName componentName, IMetricInfo[] infos)
    throws Exception
    {
        super(new ParentNode(MetricsFactory.createMetricIdentity(""), ""));
        m_connector = connector;
        m_componentName = componentName;
        m_canonicalName =  m_componentName.getCanonicalName();
        m_treeRootNode = getTreeRootNode();
    }
    
    private ParentNode getTreeRootNode() {
        return (ParentNode)super.getRoot();
    }

    @Override
    public CollationKey getCollationKey(Object object)
    {
        if (object instanceof IMetricInfo)
        {
            return Sorter.COLLATOR.getCollationKey(((IMetricInfo)object).getMetricIdentity().getName());
        }
        if (object instanceof InstanceNode)
        {
            return Sorter.COLLATOR.getCollationKey(object.toString());
        }

        throw new IllegalArgumentException("Expected instance of IMetricInfo");
    }

    public ObjectName getComponentName() { return m_componentName; }

    public List getInstances(InstanceParentNode node)
    throws Exception
    {
        IMetricIdentity metricId = ((IMetricInfo)node.getUserObject()).getMetricIdentity();
        String[] instances = (String[])m_connector.invoke(m_componentName, "getInstanceMetricNames", new Object[] { metricId }, METRIC_ID_SIGNATURE);

        ArrayList instancesList = new ArrayList(instances.length);
        for (int i = 0; i < instances.length; i++)
        {
            instancesList.add(instances[i]);
        }

        return instancesList;
    }

    public boolean hasValueListeners(IMetricIdentity metricId)
    {
        synchronized(m_valueListeners)
        {
            HashSet listeners = (HashSet)m_valueListeners.get(metricId);

            if (listeners == null)
            {
                return false;
            }

            return !listeners.isEmpty();
        }
    }

    /**
     * Finds the matching node (if any) in the metrics tree and forces a
     * repaint of the view for that node.
     *
     * @param id    The metric identity to update in the tree model.
     */

    protected void updateNode(IMetricIdentity id)
    {
        Enumeration en = m_treeRootNode.depthFirstEnumeration();

        while (en.hasMoreElements())
        {
            AbstractNode    node     = (AbstractNode)en.nextElement();
            IMetricIdentity identity = null;

            if ((node instanceof Node) || (node instanceof InstanceParentNode))
            {
                identity = ((IMetricInfo)node.getUserObject()).getMetricIdentity();
            }
            else
            if (node instanceof InstanceNode)
            {
                identity = (IMetricIdentity)node.getUserObject();
            }

            if ((identity != null) && identity.equals(id))
            {
                final AbstractNode updatedNode = node;
                com.sonicsw.ma.gui.util.Helper.invoke(new Runnable()
                {
                    @Override
                    public void run()
                    {
                        nodeChanged(updatedNode);
                    }
                });
                break;
            }
        }
    }

    public abstract void update(IMetricInfo[] info);
    public abstract void refreshTree() throws Exception;
    public abstract void refreshMetricValues(IMetricIdentity[] id);
    public abstract void addValueListener(IMetricIdentity metricId, IValueListener listener);
    public abstract void removeValueListener(IMetricIdentity metricId, IValueListener listener);
}
