package com.sonicsw.ma.gui.runtime.metrics.model;

import java.util.EventObject;

import javax.management.ObjectName;

import com.sonicsw.mf.common.metrics.IAggregateMetric;
import com.sonicsw.mf.common.metrics.IMetricIdentity;

public class AggregateValueUpdatedEvent
extends EventObject implements IValueUpdatedEvent
{
    private static final boolean DEBUG = false;

    private IAggregateMetric m_metric;
    private String m_collectionID;

    AggregateValueUpdatedEvent(ObjectName source, IAggregateMetric metric, String collectionID)
    {
        super(source);
        m_metric = metric;
        m_collectionID = collectionID;
        if (DEBUG)
        {
            System.out.println("<AggregationResultEvent> metricID: " + m_metric.getMetricIdentity().getName() + " collectionID: " + m_collectionID);
        }
    }

    public String[] getSources() { return m_metric.getSources(); }
    @Override
    public IMetricIdentity getMetricId() { return m_metric.getMetricIdentity(); }
    public long[] getValues() { return m_metric.getValues(); }
    @Override
    public long getCurrencyTimestamp() { return m_metric.getCurrencyTimestamp(); }
    public String getCollectionID() { return m_collectionID; }
}
