package com.sonicsw.ma.gui.runtime.metrics.model;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;

import com.sonicsw.mf.common.metrics.IAlert;

public class AlertsModel
{
    private HashSet m_alerts = null;

    public void setAlerts(HashSet alerts) { m_alerts = alerts; }

    public HashSet getAlerts()
    {
        if (m_alerts == null)
        {
            m_alerts = new HashSet();
        }

        return m_alerts;
    }

    public ArrayList getLowThresholdValues()
    {
        ArrayList list = new ArrayList(0);

        if (m_alerts != null)
        {
            Iterator i = m_alerts.iterator();
            while(i.hasNext())
            {
                IAlert alert = (IAlert)i.next();
                if(!alert.isHighThreshold())
                {
                    list.add(new Long(alert.getThresholdValue()));
                }
            }
        }

        return list;
    }

    public ArrayList getHighThresholdValues()
    {
        ArrayList list = new ArrayList(0);

        if (m_alerts != null)
        {
            Iterator iterator = m_alerts.iterator();
            while (iterator.hasNext())
            {
                IAlert alert = (IAlert)iterator.next();
                if (alert.isHighThreshold())
                {
                    list.add(new Long(alert.getThresholdValue()));
                }
            }
        }

        return list;
    }
}