package com.sonicsw.ma.gui.runtime.metrics.model;

import com.sonicsw.ma.gui.runtime.util.AbstractNode;

import com.sonicsw.mf.common.metrics.IMetricIdentity;
import com.sonicsw.mf.common.metrics.IMetricInfo;

public final class InstanceNode extends AbstractNode
                                implements IAlertsProvider
{
    private AlertsModel m_alertsModel;

    public InstanceNode(IMetricIdentity metricIdentity, String name) { super(metricIdentity, false, name); }

    @Override
    public String getDescription()
    {
        StringBuffer buffer = new StringBuffer();
        buffer.append(((IMetricInfo)((InstanceParentNode)super.getParent()).getUserObject()).getDescription());
        buffer.append(" [Applied to \"").append(super.toString()).append("\"]");
        return buffer.toString();
    }

    // override super behavior as we cannot determine if the parent should be enabled (because
    // instances may come and go and the parent will not know about all instances at any point in time)
    @Override
    public void setParentEnabled() { }

    @Override
    public boolean supportsAlerts()
    {
        IMetricInfo info = (IMetricInfo)((InstanceParentNode)super.getParent()).getUserObject();
        return (info.supportsHighThresholdAlerts() || info.supportsLowThresholdAlerts());
    }

    @Override
    public AlertsModel getAlertsModel()
    {
        if (supportsAlerts())
        {
            if (m_alertsModel == null)
            {
                m_alertsModel = new AlertsModel();
            }
            return m_alertsModel;
        }

        return null;
    }
}