package com.sonicsw.ma.gui.runtime.metrics.model;

import com.sonicsw.ma.gui.runtime.util.AbstractParentNode;

import com.sonicsw.mf.common.metrics.IMetricInfo;

public final class InstanceParentNode extends AbstractParentNode 
                                      implements IAlertsProvider
{
    private AlertsModel m_alertsModel;

    public InstanceParentNode(IMetricInfo metricInfo, String name) { super(metricInfo, name); }

    @Override
    public String getDescription()
    {
        return ((IMetricInfo)super.userObject).getDescription();
    }

    @Override
    public boolean supportsAlerts()
    {
        IMetricInfo info = (IMetricInfo)super.getUserObject();
        return (info.supportsHighThresholdAlerts() || info.supportsLowThresholdAlerts());
    }

    @Override
    public AlertsModel getAlertsModel()
    {
        if (supportsAlerts())
        {
            if (m_alertsModel == null)
            {
                m_alertsModel = new AlertsModel();
            }
            return m_alertsModel;
        }

        return null;
    }
}