package com.sonicsw.ma.gui.runtime.notifications;

import javax.management.Notification;

import com.sonicsw.mf.common.runtime.INotification;
import com.sonicsw.mf.common.runtime.Level;

public class NotificationValue
{
    private Notification m_value;
    private String       m_collectionID;

    public NotificationValue(Notification value)
    {
        this(value, null);
    }

    public NotificationValue(Notification value, String collectionID)
    {
        m_value        = value;
        m_collectionID = collectionID;
    }

    public Notification getValue()
    {
        return m_value;
    }

    public String getSource()
    {
        return m_value.getSource().toString();
    }

    public String getHost()
    {
        if (!(m_value instanceof INotification))
        {
            return "n/a";
        }

        return ((INotification) m_value).getSourceHost();
    }

    public String getNotification()
    {
        return m_value.getType();
    }

    public String getSeverity()
    {
        if (!(m_value instanceof INotification))
        {
            return "n/a";
        }

        return Level.LEVEL_TEXT[((INotification) m_value).getSeverity()];
    }

    public String getLogType()
    {
        if (!(m_value instanceof INotification))
        {
            return "n/a";
        }

        return INotification.LOGTYPE_TEXT[((INotification) m_value).getLogType()];
    }

    public Long getSequence()
    {
        if (!(m_value instanceof INotification))
        {
            return new Long(0);
        }

        return new Long(((INotification) m_value).getSequenceNumber());
    }

    public Long getTime()
    {
        return new Long(m_value.getTimeStamp());
    }

    public String getCollectionID()
    {
        return m_collectionID;
    }
}
