/**
 * Copyright (c) 2002 Sonic Software Corporation. All Rights Reserved.
 *
 * This software is the confidential and proprietary information of Sonic
 * Software Corpoation. (Confidential Information).  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sonic.
 *
 * SONIC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SONIC SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 *
 * CopyrightVersion 1.0
 */
package com.sonicsw.ma.gui.runtime.notifications;

import javax.swing.JPanel;
import javax.swing.JTextField;

import modelobjects.framework.EditRule;
import modelobjects.framework.model.ModelAspectId;
import modelobjects.framework.model.ModelObjectAdapter;
import modelobjects.framework.model.ModelObjectPropagator;
import modelobjects.framework.model.ModelObjectValidator;
import modelobjects.framework.model.ModelPropagationException;
import modelobjects.framework.model.ModelValidationException;
import modelobjects.framework.swing.JTextFieldAdapter;

import com.sonicsw.ma.gui.propsheets.JPropSheetDialog;
import com.sonicsw.ma.gui.runtime.notifications.model.INotificationWatcher;
import com.sonicsw.ma.gui.util.JMAFrame;
import com.sonicsw.ma.gui.util.JPartitionPanel;

class WatchPropSheet extends JPropSheetDialog
{
    private JTextField m_maxNotificationsField;

    public WatchPropSheet(JMAFrame parent)
    {
        super(parent, "notifications.watcher", WatchPropSheet.Model.class);

        setValidator(new Validator());
        setPropagator(new Propagator());
    }

    @Override
    public void initUI() throws Exception
    {
        getContentPane().add(createMainPanel());
    }

    @Override
    public void initForm() throws Exception
    {
        new JTextFieldAdapter(ModelAspectId.forName("maxNotifications"),
                              m_maxNotificationsField,
                              EditRule.ALWAYS,
                              null, getMediator());
    }

    private JPanel createMainPanel()
    {
        m_maxNotificationsField = new JTextField(5);

        JPartitionPanel panel = new JPartitionPanel(false, "p,r", "Watch Data");
        panel.addRow("Max Notifications", m_maxNotificationsField);

        return JPartitionPanel.wrap(panel);
    }

    //-------------------------------------------------------------------------

    public class Model
    {
        private String maxNotifications;

        INotificationWatcher watcher;

        public Model(INotificationWatcher watcher)
        {
            this.watcher = watcher;

            this.maxNotifications = Integer.toString(watcher.getMaxNotifications());
        }

        public String getMaxNotifications() { return this.maxNotifications; }
        public void setMaxNotifications(String maxNotifications) { this.maxNotifications = maxNotifications; }
    }

    private static class Validator
    implements ModelObjectValidator
    {
        @Override
        public void validateModelEdit(ModelObjectAdapter adapter)
        throws ModelValidationException
        {
            WatchPropSheet.Model model = (WatchPropSheet.Model)adapter.getModelObject();

            int maxNotifications = Integer.parseInt(model.getMaxNotifications());
            if (maxNotifications < 1)
            {
                throw new ModelValidationException("The maximum number of notifications per watch window must be > 0");
            }
            if (maxNotifications > 1000)
            {
                throw new ModelValidationException("The maximum number of notifications per watch window must be <= 1000");
            }
        }

        @Override
        public void validateModelCreation(ModelObjectAdapter adapter)
        throws ModelValidationException { throw new ModelValidationException("Create invalid");  }

        @Override
        public void validateModelDeletion(ModelObjectAdapter adapter)
        throws ModelValidationException { throw new ModelValidationException("Delete invalid");  }
    }

    private static class Propagator
    implements ModelObjectPropagator
    {
        /**
         * Propagate edits to a model object.
         *
         * @param modelObjectAdapter the ModelObjectAdapter that holds the model
         * @exception ModelPropagationException if the edits cannot be propagated
         */
        @Override
        public void propagateModelEdit(ModelObjectAdapter adapter)
        throws ModelPropagationException
        {
            WatchPropSheet.Model model = (WatchPropSheet.Model)adapter.getModelObject();

            model.watcher.setMaxNotifications(Integer.parseInt(model.getMaxNotifications()));
        }

        /**
         * Propagate a newly created model object.
         *
         * @param modelObjectAdapter the ModelObjectAdapter that holds the model
         * @exception ModelPropagationException if the create cannot be propagated
         */
        @Override
        public void propagateModelCreation(ModelObjectAdapter modelObjectAdapter)
        throws ModelPropagationException { }

        /**
         * Propagate deletion of a model object.
         *
         * @param modelObjectAdapter the ModelObjectAdapter that holds the model
         * @exception ModelPropagationException if the delete cannot be propagated
         */
        @Override
        public void propagateModelDeletion(ModelObjectAdapter modelObjectAdapter)
        throws ModelPropagationException { }
    }
}
