package com.sonicsw.ma.gui.runtime.notifications.model;

import java.text.CollationKey;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;

import javax.management.MBeanNotificationInfo;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.swing.tree.DefaultTreeModel;

import com.sonicsw.ma.gui.runtime.util.AbstractNode;
import com.sonicsw.ma.gui.runtime.util.AbstractParentNode;
import com.sonicsw.mx.util.ICollationKeyProvider;
import com.sonicsw.mx.util.IEmptyArray;
import com.sonicsw.mx.util.Sorter;

import com.sonicsw.mf.jmx.client.IRemoteMBeanServer;

public abstract class AbstractNotificationsModel
extends DefaultTreeModel
implements IEmptyArray, ICollationKeyProvider
{
    public static final boolean DEBUG = false;

    protected IRemoteMBeanServer m_connector;
    protected ObjectName m_componentName;
    protected javax.management.NotificationFilterSupport m_notificationFilter = new javax.management.NotificationFilterSupport();

    protected ParentNode m_treeRootNode;

    protected HashSet m_subscriptions = new HashSet();
    protected Hashtable m_notificationListeners = new Hashtable();

    public AbstractNotificationsModel(IRemoteMBeanServer connector, ObjectName componentName, MBeanNotificationInfo[] infos)
    {
        super(new ParentNode("", ""));

        m_connector = connector;
        m_componentName = componentName;
        m_treeRootNode = getTreeRootNode(); 
        Sorter.sort(infos, this, infos.length);
    }
    
    private ParentNode getTreeRootNode() {
        return (ParentNode)super.getRoot();
    }

    /**
     * Copied out of MFNotification because its deprecated and its just a UI (SMC) helper method
     * to easily build up '.' delimited strings that represent notificationTypes.
     * 
     * @param notificationTypes  A string array of notificationType component parts
     * @return                   The dot-delimited string representing the notification type
     */
    public static String getTypePrefix(String[] notificationTypes)
    {
        StringBuffer sb = new StringBuffer(notificationTypes[0]);
        
        if (notificationTypes.length > 1)
        {
            for (int i = 1; i < notificationTypes.length; i++)
            {
                sb.append('.').append(notificationTypes[i]);
            }
        }

        return sb.toString();
    }
    
    @Override
    public CollationKey getCollationKey(Object object)
    {
        if (object instanceof MBeanNotificationInfo)
        {
            return Sorter.COLLATOR.getCollationKey(getTypePrefix(((MBeanNotificationInfo)object).getNotifTypes()));
        }

        throw new IllegalArgumentException("Expected instance of MBeanNotificationInfo");
    }

    public ObjectName getComponentName() { return m_componentName; }

    public abstract void unsubscribeNotification(AbstractNode node) throws Exception;

    public abstract void subscribeNotification(AbstractNode node) throws Exception ;

    public void addNotificationListener(String prefix, NotificationListener listener)
    throws Exception
    {
        synchronized(m_notificationListeners)
        {
            HashSet listeners = (HashSet)m_notificationListeners.get(prefix);
            if (listeners == null)
            {
                listeners = new HashSet();
                m_notificationListeners.put(prefix, listeners);
                if (DEBUG)
                {
                    System.out.println("Add Listener: "  + prefix + "[" + this + "]");
                }
                setNodeEnabled(prefix, true);
            }
            listeners.add(listener);
            if (DEBUG)
            {
                System.out.println("");
            }
        }
    }

    public void removeNotificationListener(String prefix, NotificationListener listener)
    throws Exception
    {
        synchronized(m_notificationListeners)
        {
            HashSet listeners = (HashSet)m_notificationListeners.get(prefix);
            if (listeners != null)
            {
                listeners.remove(listener);
                if (listeners.isEmpty())
                {
                    m_notificationListeners.remove(prefix);
                    setNodeEnabled(prefix, false);
                }
            }
        }
    }

    /**
     * Returns a list of all the notifications that are related to the supplied
     * node parameter. It basically enumerates through the notifications
     * hierarchy adding each leaf-node (concrete notifications info) to a
     * return list.
     *
     * @param node  A tree node in the notifications model hierarchy under
     *              which all notifications are to be gathered.
     * @return      A typed list of all the notification info's that are
     *              related to the node parameter.
     */
    public MBeanNotificationInfo[] getChildNotifications(AbstractNode node)
    {
        ArrayList res = new ArrayList();

        if (node instanceof Node)
        {
            res.add(node.getUserObject());
        }
        else // walk the children
        {
            Enumeration en = ((AbstractParentNode)node).depthFirstEnumeration();

            while (en.hasMoreElements())
            {
                node = (AbstractNode)en.nextElement();

                if (node instanceof Node)
                {
                    res.add(node.getUserObject());
                }
            }
        }

        return (MBeanNotificationInfo[])res.toArray(new MBeanNotificationInfo[res.size()]);
    }

    void setNodeEnabled(String prefix, boolean enabled)
    throws Exception
    {
        Enumeration en = m_treeRootNode.depthFirstEnumeration();

        while (en.hasMoreElements())
        {
            AbstractNode node = (AbstractNode)en.nextElement();
            if (node instanceof Node && getTypePrefix(((MBeanNotificationInfo)((Node)node).getUserObject()).getNotifTypes()).equals(prefix))
            {
                node.setEnabled(enabled);
                if (!enabled)
                {
                    unsubscribeNotification(node);
                }
            }
        }
    }

    public AbstractNode findBranchRoot(AbstractNode node)
    {
        while (node != m_treeRootNode)
        {
            node = (AbstractNode)node.getParent();
        }

        return node;
    }

    void fireNodeChanged(AbstractNode node)
    {
        if (node == null)
        {
            return;
        }
        if (node == m_treeRootNode)
        {
            return;
        }

        super.nodeChanged(node);
        fireNodeChanged((AbstractNode)node.getParent());
    }
}