package com.sonicsw.ma.gui.runtime.notifications.model;

import java.rmi.dgc.VMID;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Vector;

import javax.management.MBeanNotificationInfo;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.management.ObjectName;

import com.sonicsw.ma.gui.MgmtConsole;
import com.sonicsw.ma.gui.runtime.util.AbstractNode;
import com.sonicsw.ma.gui.runtime.util.AbstractParentNode;

import com.sonicsw.mf.jmx.client.IRemoteMBeanServer;
import com.sonicsw.mf.jmx.client.MFNotification;

public class ForwardedNotificationsModel
extends AbstractNotificationsModel
implements  NotificationListener
{
    public static final boolean DEBUG = false;

    private String       m_handback         = new VMID().toString();
    private String       m_collectionName   = null;
    private ObjectName   m_objComponentName = null;

    public ForwardedNotificationsModel(IRemoteMBeanServer connector, ObjectName componentName, MBeanNotificationInfo[] infos, String collectionName)
    throws Exception
    {
        super(connector, componentName, infos);
        m_collectionName = collectionName;
        m_objComponentName = componentName;
        constructTree(infos, false);

    }

    public String getCollectionID()
    {
        return m_collectionName;
    }


    @Override
    public void subscribeNotification(AbstractNode node)
    throws Exception
    {
        MBeanNotificationInfo[] notifications = getChildNotifications(node);
        Vector subscribedPrefixes = m_notificationFilter.getEnabledTypes();

        if (DEBUG)
        {
            Enumeration en = subscribedPrefixes.elements();
            System.out.println(">>>>>>");
            while (en.hasMoreElements())
            {
                System.out.println(en.nextElement().toString());
            }
            System.out.println("<<<<<<");
        }

        boolean foundNewSubscription = false;
        for (int i = notifications.length - 1; i >= 0; i--)
        {
            String prefix = getTypePrefix(notifications[i].getNotifTypes());
            if (!subscribedPrefixes.contains(prefix))
            {
                foundNewSubscription = true;
                m_notificationFilter.enableType(prefix);
            }
        }

        if (foundNewSubscription)
        {
            m_connector.addNotificationListener(m_componentName, this, m_notificationFilter, m_handback);
        }

        node.setEnabled(true);
        node.setParentEnabled();
        fireNodeChanged(node);
    }

    @Override
    public void unsubscribeNotification(AbstractNode node)
    throws Exception
    {
        MBeanNotificationInfo[] notifications = getChildNotifications(node);
        Vector subscribedPrefixes = m_notificationFilter.getEnabledTypes();

        for (int i = notifications.length - 1; i >= 0; i--)
        {
            String prefix = getTypePrefix(notifications[i].getNotifTypes());
            if (subscribedPrefixes.contains(prefix))
            {
                m_notificationFilter.disableType(prefix);
            }
        }

        new Thread()
        {
            @Override
            public void run()
            {
                try
                {
                    if (m_notificationFilter.getEnabledTypes().size() == 0)
                    {
                        ForwardedNotificationsModel.this.m_connector.removeNotificationListener(ForwardedNotificationsModel.this.m_componentName, ForwardedNotificationsModel.this);
                    }
                    else
                    {
                        ForwardedNotificationsModel.this.m_connector.addNotificationListener(ForwardedNotificationsModel.this.m_componentName, ForwardedNotificationsModel.this, ForwardedNotificationsModel.this.m_notificationFilter, ForwardedNotificationsModel.this.m_handback);
                    }
                } catch(Exception e) { 
                   MgmtConsole.getMgmtConsole().notifyMessage(MgmtConsole.ERROR, e.getMessage(), e, false);    // Log the error msg.
                } 
            }
        }.start();

        node.setEnabled(false);
        node.setParentEnabled();
        fireNodeChanged(node);
    }

    @Override
    public void handleNotification(Notification notification, Object handback)
    {
        Object[] listeners = null;
        if (!handback.equals(m_handback))
        {
            return;
        }
        synchronized(m_notificationListeners)
        {
            HashMap attrs = ((MFNotification)notification).getAttributes();
            String forwardedBy = (String)attrs.get("ForwardedBy");

            if(forwardedBy == null)
            {
                return;
            }
            if(!forwardedBy.equals(m_componentName.getCanonicalName()))
            {
                return;
            }

            handback = m_collectionName;

            HashSet listenerSet = (HashSet)m_notificationListeners.get(notification.getType());
            if (listenerSet == null)
            {
                return;
            }
            listeners = listenerSet.toArray();
        }

        for (int i = 0; i < listeners.length; i++)
        {
            ((NotificationListener)listeners[i]).handleNotification(notification, handback);
        }

    }

    public void refreshTree()
    throws Exception
    {
        try
        {
            Object parameters[]          = { m_collectionName, };
            String signatures[]          = { String.class.getName(), };
            MBeanNotificationInfo[] info =
               (MBeanNotificationInfo[])m_connector.invoke( m_objComponentName,
                                                            "getForwardedNotificationsInfo",
                                                            parameters,
                                                            signatures);
            refreshTree(info);
            super.nodeStructureChanged(m_treeRootNode);
        }
        catch(Exception e)
        {
           throw e;
        }
    }

    public void refreshTree(MBeanNotificationInfo[] infos)
    throws Exception
    {
        Enumeration en = m_treeRootNode.depthFirstEnumeration();
        while (en.hasMoreElements())
        {
            AbstractNode node = (AbstractNode)en.nextElement();

            if (node == m_treeRootNode)
            {
                continue;
            }

            if (node instanceof Node)
            {
                MBeanNotificationInfo info = (MBeanNotificationInfo)node.getUserObject();
                if (!inNewList(info, infos))
                {
                    ParentNode parent = (ParentNode)node.getParent();
                    //first see if we need to remove  and unsubscribe listener
                    deleteNotificationListener(node);
                    parent.remove(node);
                    updateEnabledState(parent);
                    super.nodeChanged(parent);
                }
            }
            else if (node instanceof ParentNode)
            {
                if ( node.getChildCount() == 0 )
                {
                    ParentNode parent = (ParentNode)node.getParent();
                    parent.remove(node);
                    super.nodeChanged(parent);
                }
            }
        }
        constructTree(infos, true);
    }

    private void updateEnabledState(AbstractParentNode parent)
    {
        Enumeration en = parent.children();
        while (en.hasMoreElements())
        {
            AbstractNode child = (AbstractNode)en.nextElement();
            if (child.isEnabled())
            {
                child.setParentEnabled();
                break;
            }
        }
    }

    private boolean inNewList(MBeanNotificationInfo info, MBeanNotificationInfo[] newList )
    {
        boolean result = false;
        for (int i = 0; i < newList.length; i++)
        {
            if (info.equals(newList[i]))
            {
                return true;
            }
        }
        return result;
    }


    /**
     * Construct the notifications node tree from the notifications info.
     */
    private void constructTree(MBeanNotificationInfo[] infos, boolean refresh)
    {
        for (int i = 0; i < infos.length; i++)
        {
            AbstractParentNode parent = m_treeRootNode;
            String[] nameTokens = infos[i].getNotifTypes();
            StringBuffer prefix = new StringBuffer();
            for (int j = 0; j < nameTokens.length; j++)
            {
                if (j == nameTokens.length - 1)
                {

                    if (parent.getChild(nameTokens[j]) == null)
                    {
                        parent.add((AbstractNode)new Node(infos[i], nameTokens[j]));
                        if(refresh)
                        {
                            updateEnabledState(parent);
                        }
                    }
                }
                else
                {
                    if (j > 0)
                    {
                        prefix.append('.');
                    }
                    prefix.append(nameTokens[j]);
                    AbstractParentNode childNode = (AbstractParentNode)parent.getChild(nameTokens[j]);
                    if (childNode == null)
                    {
                        childNode = new ParentNode(prefix.toString(), nameTokens[j]);
                        parent.add(childNode);
                    }
                    parent = childNode;
                }
            }
        }
    }

    private void deleteNotificationListener(AbstractNode node)
    {
        MBeanNotificationInfo info = (MBeanNotificationInfo)node.getUserObject();
        String prefix = getTypePrefix(info.getNotifTypes());

        //remove
        synchronized(m_notificationListeners)
        {
            HashSet listeners = (HashSet)m_notificationListeners.get(prefix);
            if (listeners != null)
            {

                //node for the specified prefix has been deleted
                //so we have to remove all listeners
                listeners.clear();
                if (listeners.isEmpty())
                {
                    m_notificationListeners.remove(prefix);
                }
            }
        }
        //unsubscribe
        Vector subscribedPrefixes = m_notificationFilter.getEnabledTypes();
        if (subscribedPrefixes.contains(prefix))
        {
            m_notificationFilter.disableType(prefix);
            new Thread()
            {
                @Override
                public void run()
                {
                    try
                    {
                        if (m_notificationFilter.getEnabledTypes().size() == 0)
                        {
                            ForwardedNotificationsModel.this.m_connector.removeNotificationListener(ForwardedNotificationsModel.this.m_componentName, ForwardedNotificationsModel.this);
                        }
                        else
                        {
                            ForwardedNotificationsModel.this.m_connector.addNotificationListener(ForwardedNotificationsModel.this.m_componentName, ForwardedNotificationsModel.this, ForwardedNotificationsModel.this.m_notificationFilter, ForwardedNotificationsModel.this.m_handback);
                        }
                    } catch(Exception e) { 
                        MgmtConsole.getMgmtConsole().notifyMessage(MgmtConsole.ERROR, e.getMessage(), e, false);    // Log the error msg.
                    }
            }
            }.start();
        }
    }




}