package com.sonicsw.ma.gui.runtime.notifications.model;

import java.rmi.dgc.VMID;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Vector;

import javax.management.MBeanNotificationInfo;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.management.ObjectName;

import com.sonicsw.ma.gui.MgmtConsole;
import com.sonicsw.ma.gui.runtime.util.AbstractNode;
import com.sonicsw.ma.gui.runtime.util.AbstractParentNode;

import com.sonicsw.mf.jmx.client.IRemoteMBeanServer;

public class NotificationsModel
extends AbstractNotificationsModel
implements NotificationListener
{
    public static final boolean DEBUG = false;
    private String m_handback = new VMID().toString();

    public NotificationsModel(IRemoteMBeanServer connector, ObjectName componentName, MBeanNotificationInfo[] infos)
    throws Exception
    {
        super(connector, componentName, infos);
        constructTree(infos);
    }

    @Override
    public void subscribeNotification(AbstractNode node)
    throws Exception
    {
        MBeanNotificationInfo[] notifications = getChildNotifications(node);
        Vector subscribedPrefixes = m_notificationFilter.getEnabledTypes();

        if (DEBUG)
        {
            Enumeration en = subscribedPrefixes.elements();
            System.out.println(">>>>>>");
            while (en.hasMoreElements())
            {
                System.out.println(en.nextElement().toString());
            }
            System.out.println("<<<<<<");
        }

        boolean foundNewSubscription = false;
        for (int i = notifications.length - 1; i >= 0; i--)
        {
            String prefix = getTypePrefix(notifications[i].getNotifTypes());
            if (!subscribedPrefixes.contains(prefix))
            {
                foundNewSubscription = true;
                m_notificationFilter.enableType(prefix);
            }
        }

        if (foundNewSubscription)
        {
            m_connector.addNotificationListener(m_componentName, this, m_notificationFilter, m_handback);
        }

        node.setEnabled(true);
        node.setParentEnabled();
        fireNodeChanged(node);
    }

    @Override
    public void unsubscribeNotification(AbstractNode node)
    throws Exception
    {
        MBeanNotificationInfo[] notifications = getChildNotifications(node);
        Vector subscribedPrefixes = m_notificationFilter.getEnabledTypes();

        for (int i = notifications.length - 1; i >= 0; i--)
        {
            String prefix = getTypePrefix(notifications[i].getNotifTypes());
            if (subscribedPrefixes.contains(prefix))
            {
                m_notificationFilter.disableType(prefix);
            }
        }

        new Thread()
        {
            @Override
            public void run()
            {
                try
                {
                    if (m_notificationFilter.getEnabledTypes().size() == 0)
                    {
                        NotificationsModel.this.m_connector.removeNotificationListener(NotificationsModel.this.m_componentName, NotificationsModel.this);
                    }
                    else
                    {
                        NotificationsModel.this.m_connector.addNotificationListener(NotificationsModel.this.m_componentName, NotificationsModel.this, NotificationsModel.this.m_notificationFilter, NotificationsModel.this.m_handback);
                    }
                } catch(Exception e) { 
                    MgmtConsole.getMgmtConsole().notifyMessage(MgmtConsole.ERROR, e.getMessage(), e, false);    // Log the error msg.
                }
            }
        }.start();

        node.setEnabled(false);
        node.setParentEnabled();
        fireNodeChanged(node);
    }

    @Override
    public void handleNotification(Notification notification, Object handback)
    {
        if (!handback.equals(m_handback))
        {
            return;
        }

        Object[] listeners = null;

        synchronized(m_notificationListeners)
        {
            HashSet listenerSet = (HashSet)m_notificationListeners.get(notification.getType());
            if (listenerSet == null)
            {
                return;
            }
            listeners = listenerSet.toArray();
        }

        for (int i = 0; i < listeners.length; i++)
        {
            ((NotificationListener)listeners[i]).handleNotification(notification, handback);
        }
    }

    /**
     * Construct the notifications node tree from the notifications info.
     */
    private void constructTree(MBeanNotificationInfo[] infos)
    {
        for (int i = 0; i < infos.length; i++)
        {
            AbstractParentNode parent = m_treeRootNode;
            String[] nameTokens = infos[i].getNotifTypes();
            StringBuffer prefix = new StringBuffer();
            for (int j = 0; j < nameTokens.length; j++)
            {
                if (j == nameTokens.length - 1)
                {

                    if (parent.getChild(nameTokens[j]) == null)
                    {
                        parent.add((AbstractNode)new Node(infos[i], nameTokens[j]));
                    }
                }
                else
                {
                    if (j > 0)
                    {
                        prefix.append('.');
                    }
                    prefix.append(nameTokens[j]);
                    AbstractParentNode childNode = (AbstractParentNode)parent.getChild(nameTokens[j]);
                    if (childNode == null)
                    {
                        childNode = new ParentNode(prefix.toString(), nameTokens[j]);
                        parent.add(childNode);
                    }
                    parent = childNode;
                }
            }
        }
    }
}