/**
 * Copyright (c) 2002 Sonic Software Corporation. All Rights Reserved.
 *
 * This software is the confidential and proprietary information of Sonic
 * Software Corpoation. (Confidential Information).  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sonic.
 *
 * SONIC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SONIC SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 *
 * CopyrightVersion 1.0
 */
package com.sonicsw.ma.gui.runtime.propsheets;

import javax.management.ObjectName;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JTextArea;
import javax.swing.JTextField;

import modelobjects.framework.EditRule;
import modelobjects.framework.ViewValueConverter;
import modelobjects.framework.model.ModelAspectId;
import modelobjects.framework.model.ModelDescriptor;
import modelobjects.framework.swing.JCheckBoxAdapter;
import modelobjects.framework.swing.JComboBoxAdapter;
import modelobjects.framework.swing.JLabelAdapter;
import modelobjects.framework.swing.JTextAreaAdapter;
import modelobjects.framework.swing.JTextFieldAdapter;

import com.sonicsw.ma.gui.propsheets.JPropSheetDialog;
import com.sonicsw.ma.gui.util.GUIException;
import com.sonicsw.ma.gui.util.JMAFrame;
import com.sonicsw.ma.gui.util.ResourceManager;
import com.sonicsw.ma.plugin.IPlugin;
import com.sonicsw.ma.plugin.IRuntimePlugin;

import com.sonicsw.mf.jmx.client.IRemoteMBeanServer;


public abstract class JRuntimeDialog extends JPropSheetDialog
{
    public JRuntimeDialog(JMAFrame parent, String name)
    {
        super(parent, name, RuntimeBean.class);

    }

    public JRuntimeDialog(JRuntimeDialog parent, String name)
    {
        super(parent, name, RuntimeBean.class);
    }

    @Override
    protected ModelDescriptor makeModelDescriptor()
    {
        return new RuntimeModelDescriptor();
    }

    @Override
    public void editInstance(IPlugin plugin, Object model, boolean isNew)
    throws Exception
    {
        RuntimeBean            bean   = (RuntimeBean)model;
        IRemoteMBeanServer     server = bean.getServer();
        RuntimeModelDescriptor desc   = (RuntimeModelDescriptor)getDescriptor();

        ObjectName objName = bean.getName();
        String     name    = ((IRuntimePlugin)plugin).getPluginName();

        if (objName == null)
        {
            throw new GUIException("Management information is not available.\nMake sure '" + name + "' has a host.");
        }

        // Get the runtime bean to read all runtime attributes and cache them.
        bean.cacheAllAttributes();

        desc.addModelAspectAdapters(server.getMBeanInfo(objName).getAttributes());

        super.editInstance(plugin, model, isNew);

        // Set the dialog title based on whether the model is new or existing.
        String titlePrefix = "";
        String title = "";
        String titleSuffix = "";

        if (isNew)
        {
            titlePrefix = ResourceManager.getString(getClass(),"JMADialog.newTitlePrefix");
            title = titlePrefix + " " + getTitle();
        }
        else
        {
            titlePrefix = ResourceManager.getString(getClass(),"JMADialog.editTitlePrefix");
            titleSuffix = ResourceManager.getString(getClass(),"JMADialog.editTitleSuffix");
            title = titlePrefix + " " + getTitle() + " " + titleSuffix;
        }

        setTitle(title);
    }

    public String getResourceLabel(String key)
    {
        return ResourceManager.getString(getClass(), new Object[] { ResourceManager.KEY_RUNTIME, key, ResourceManager.KEY_LABEL });
    }

    public String getResourceUnit(String key)
    {
        return ResourceManager.getString(getClass(), new Object[] { ResourceManager.KEY_UNIT, key });
    }

    public JLabelAdapter createJLabelAdapter(String             attributeName,
                                             JLabel             viewComponent,
                                             ViewValueConverter converter)
    {
        return new JLabelAdapter(ModelAspectId.forName(attributeName), viewComponent,
                     converter, getEditForm().getModelEditMediator());
    }

    public JTextFieldAdapter createJTextFieldAdapter(String             attributeName,
                                                     JTextField         field,
                                                     ViewValueConverter converter)
    {
        return new JTextFieldAdapter(ModelAspectId.forName(attributeName), field, EditRule.ALWAYS,
                     converter, getEditForm().getModelEditMediator());
    }

    public JTextAreaAdapter createJTextAreaAdapter(String             attributeName,
                                                   JTextArea          field,
                                                   ViewValueConverter converter)
    {
        return new JTextAreaAdapter(ModelAspectId.forName(attributeName), field, EditRule.ALWAYS,
                     converter, getEditForm().getModelEditMediator());
    }

    public JComboBoxAdapter createJComboBoxAdapter(String             attributeName,
                                                   JComboBox          field,
                                                   ViewValueConverter converter)
    {
        return new JComboBoxAdapter(ModelAspectId.forName(attributeName), field, EditRule.ALWAYS,
                     converter, getEditForm().getModelEditMediator());
    }

    public JCheckBoxAdapter createJCheckBoxAdapter(String attributeName,
                                                   JCheckBox          field,
                                                   ViewValueConverter converter)
    {
        return new JCheckBoxAdapter(ModelAspectId.forName(attributeName), field, EditRule.ALWAYS,
                     converter, getEditForm().getModelEditMediator());
    }

}
