package com.sonicsw.ma.gui.runtime.propsheets;

import java.beans.PropertyVetoException;

import javax.management.MBeanAttributeInfo;

import com.sonicsw.ma.gui.MgmtConsole;

import modelobjects.framework.model.ModelAspectAdapter;
import modelobjects.framework.model.ModelAspectId;
import modelobjects.framework.model.ModelDescriptor;
import modelobjects.framework.model.ModelObjectAdapter;

/**
 * AttributeMaps use IAttributeDescriptionMap objects to describe their meta-data.
 * The meta-data is needed to create a ModelDescriptor for the attribute map.
 */
public class RuntimeModelDescriptor extends ModelDescriptor
{
    public static final String ATTRIBUTE_NAME = "_NAME";


    public RuntimeModelDescriptor()
    {
        super(RuntimeBean.class);

        addModelAspectAdapter(new RuntimeNameAspectAdapter());
    }

    public void addModelAspectAdapters(MBeanAttributeInfo[] attributes)
    {
        for (int i = 0; i < attributes.length; i++)
        {
            try
            {
                ModelAspectAdapter adapter = new RuntimeModelAspectAdapter(attributes[i].getName(),
                                                                       Class.forName(attributes[i].getType()),
                                                                       !attributes[i].isWritable());
                addModelAspectAdapter(adapter);
            }
            catch (ClassNotFoundException e)
            {
              System.err.println("Failed to find class (" + attributes[i].getType() +
                                 ") for runtime attribute <" + attributes[i].getName() + ">");
              MgmtConsole.getMgmtConsole().notifyMessage(MgmtConsole.ERROR, e.getMessage(), e, false);    // Log the error msg.
            }
        }
    }

    //-------------------------------------------------------------------------

    public class RuntimeNameAspectAdapter extends ModelAspectAdapter
    {
        public RuntimeNameAspectAdapter()
        {
           super(ModelAspectId.forName(ATTRIBUTE_NAME), String.class);
        }

        @Override
        public boolean isReadonlyAspect()
        {
            return true;
        }

        @Override
        protected Object getAspectValue(Object             modelObject,
                                        ModelObjectAdapter modelObjectAdapter)
        {
            Object      res  = null;
            RuntimeBean bean = (RuntimeBean)modelObject;

            res = bean.getName().toString();
            //res = bean.getIdentity().getCanonicalName();

            return res;
        }

        @Override
        protected void setAspectValue(Object             modelObject,
                                      Object             newAspectValue,
                                      ModelObjectAdapter modelObjectAdapter)
        throws PropertyVetoException,
               IllegalArgumentException,
               UnsupportedOperationException
        {
        }
    }

    //-------------------------------------------------------------------------

}
