package com.sonicsw.ma.gui.runtime.util;

import java.util.Enumeration;

import javax.swing.tree.DefaultMutableTreeNode;

public abstract class AbstractNode
extends DefaultMutableTreeNode
{
    boolean m_isEnabled = false;
    private String m_name;

    protected AbstractNode(Object userObject, boolean allowsChildren, String name)
    {
        super(userObject, allowsChildren);
        m_name = name;
    }

    @Override
    public String toString() { return m_name; }

    public boolean isEnabled() { return m_isEnabled; }

    public void setEnabled(boolean enabled) { m_isEnabled = enabled; }

    public void setParentEnabled()
    {
        if (super.parent == null)
        {
            return;
        }

        // if all the parents children (i.e. this nodes siblings are enabled/disabled)
        // then the parents enabled state can be set
        // Note: Since instance metric nodes are a special case they override this
        //       behavior
        Enumeration en = super.parent.children();
        while (en.hasMoreElements())
        {
            AbstractNode child = (AbstractNode)en.nextElement();
            if (!child.isEnabled())
            {
                ((AbstractNode)super.parent).m_isEnabled = false;
                // now test the parents parent
                ((AbstractNode)super.parent).setParentEnabled();
                return; // don't need to go further in this enumeration
            }
        }

        ((AbstractNode)super.parent).m_isEnabled = true;
        // now test the parents parent
        ((AbstractNode)super.parent).setParentEnabled();
    }

    public abstract String getDescription();
}