package com.sonicsw.ma.gui.runtime.util;

import java.util.Enumeration;

public abstract class AbstractParentNode extends AbstractNode
{
    protected AbstractParentNode(Object userObject, String name) { super(userObject, true, name); }

    public AbstractNode getChild(String childName)
    {
        int childCount = super.getChildCount();

        for (int i = 0; i < childCount; i++)
        {
            AbstractNode node = (AbstractNode)super.getChildAt(i);
            if (node.toString().equals(childName))
            {
                return node;
            }
        }

        return null;
    }

    @Override
    public void setEnabled(boolean enabled)
    {
        // enable the children (who will enable/disable their children if they are parents)
        Enumeration en = super.children();
        while (en.hasMoreElements())
        {
            ((AbstractNode)en.nextElement()).setEnabled(enabled);
        }

        super.m_isEnabled = enabled;
    }

    public boolean isAncestorEnabled() { return isAncestorEnabled(this); }

    private boolean isAncestorEnabled(AbstractParentNode parentNode)
    {
        // walk to the tree to see if any child or child of child is enabled
        Enumeration en = parentNode.children();
        while (en.hasMoreElements())
        {
            AbstractNode child = (AbstractNode)en.nextElement();
            if (child.isEnabled())
            {
                return true;
            }
            if (child instanceof AbstractParentNode && isAncestorEnabled((AbstractParentNode)child))
            {
                return true;
            }
        }

        return false;
    }
}
