package com.sonicsw.ma.gui.runtime.util;

public interface IWatcher
{
    /** The scope of a implementation that is watching data for the whole domain runtime */
    public static final short DOMAIN_SCOPE = 0;

    /** The scope of a implementation that is watching data for a runtime container */
    public static final short CONTAINER_SCOPE = 1;

    /** The scope of a implementation that is watching data for a runtime component */
    public static final short COMPONENT_SCOPE = 2;

    /** The scope of a implementation that is watching data for a runtime component */
    public static final short ITEM_SCOPE = 3;

    /**
     * @return The scope of the watcher
     *
     * @see #DOMAIN_SCOPE
     * @see #CONTAINER_SCOPE
     * @see #COMPONENT_SCOPE
     */
    public short getWatchScope();
}