/**
 * Copyright (c) 2002 Sonic Software Corporation. All Rights Reserved.
 *
 * This software is the confidential and proprietary information of Sonic
 * Software Corpoation. (Confidential Information).  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sonic.
 *
 * SONIC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SONIC SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 *
 * CopyrightVersion 1.0
 */
package com.sonicsw.ma.gui.table;

import com.sonicsw.ma.gui.util.ExtendedJTable;
import com.sonicsw.mx.config.IAttributeMap;
import com.sonicsw.mx.config.IConfigPath;

/**
 * This class is a column for a Row Model of type IAttributeMap
 */
public class AttributeMapColumn extends RowTableColumn
{
  private IConfigPath m_path;


  public AttributeMapColumn(int modelIndex, String colName, IConfigPath path)
  {
    this(modelIndex, colName, path, 100);
  }

  public AttributeMapColumn(int         modelIndex,
                            String      colName,
                            IConfigPath path,
                            int         width)
  {
    super(modelIndex, colName, width);

    setCellRenderer();

    m_path = path;
  }

  private void setCellRenderer() {
      setCellRenderer(new ExtendedJTable.ExtendedTableCellRenderer());
  }
  
  @Override
public Object getColumnValue(Object rowModel)
  {
    IAttributeMap map   = (IAttributeMap)rowModel;
    Object        value = map.getAttribute(m_path);

    return (value == null) ? "" : value.toString();
  }
}
