/**
 * Copyright (c) 2002 Sonic Software Corporation. All Rights Reserved.
 *
 * This software is the confidential and proprietary information of Sonic
 * Software Corpoation. (Confidential Information).  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sonic.
 *
 * SONIC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SONIC SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 *
 * CopyrightVersion 1.0
 */
package com.sonicsw.ma.gui.table;

import com.sonicsw.ma.plugin.IPlugin;
import com.sonicsw.mx.config.IAttributeList;

public abstract class AttributeMapContentPane extends AbstractTableContentPane
{
    public AttributeMapContentPane(IPlugin plugin)
    {
        super(plugin);
    }

    @Override
    public void setTableData(IPlugin plugin)
    {
        //Get the top level AttributeList that contains the AttributeMap
        IAttributeList theList = getRowModelList(plugin);

        ModelListTableModel tableModel = (ModelListTableModel)m_table.getModel();

        tableModel.clear();

        for (int i = 0; i < theList.size(); i++)
        {
            tableModel.addRow(theList.get(i));
        }
    }

    protected abstract IAttributeList getRowModelList(IPlugin plugin);
}
