package com.sonicsw.ma.gui.table;

import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;

import com.sonicsw.ma.gui.MgmtConsole;

/**
 *  BeanPropertyTableColumn is a subclass of RowTableColumn
 *  that uses the read-method and write-method of a JavaBeans property
 *  to get and set column values.
 */
public class BeanPropertyTableColumn extends RowTableColumn
{
    private Method m_readMethod;
    private Method m_writeMethod;

    public BeanPropertyTableColumn(int                modelIndex,
                                   PropertyDescriptor propDesc,
                                   int                width)
    {
        super(modelIndex, capitalize(propDesc.getName()), width);

        setEditable(propDesc.getWriteMethod() != null);

        m_readMethod  = propDesc.getReadMethod();
        m_writeMethod = propDesc.getWriteMethod();
    }

    @Override
    public Object getColumnValue(Object rowModel)
    {
        Object value = null;

        try
        {
            Object v = m_readMethod.invoke(rowModel, null);

            if ((v == null) || (v instanceof Number) || (v instanceof Boolean))
            {
                value = v;
            }
            else
            {
                value =  v.toString();
            }
        }
        catch (Exception e)
        {
            e.printStackTrace();
            MgmtConsole.getMgmtConsole().notifyMessage(MgmtConsole.ERROR, e.getMessage(), e, false);    // Log the error msg.
        }

        return value;
    }

    @Override
    public void setColumnValue(Object rowModel, Object columnValue)
    {
        try
        {
            m_writeMethod.invoke(rowModel, new Object[] { columnValue });
        }
        catch (Exception e)
        {
            e.printStackTrace();
            MgmtConsole.getMgmtConsole().notifyMessage(MgmtConsole.ERROR, e.getMessage(), e, false);    // Log the error msg.
        }
    }

    public static String capitalize(String name)
    {
        if ((name == null) || (name.length() == 0) || !Character.isLowerCase(name.charAt(0)))
        {
            return name;
        }
        else
        {
            return Character.toUpperCase(name.charAt(0)) + name.substring(1);
        }
    }

    private static Class getColumnType(Class propType)
    {
        if (propType.isPrimitive())
        {
            if (propType == boolean.class)
            {
                return(Boolean.class);
            }
            if (propType == byte.class)
            {
                return(Byte.class);
            }
            if (propType == char.class)
            {
                return(Character.class);
            }
            if (propType == short.class)
            {
                return(Short.class);
            }
            if (propType == int.class)
            {
                return(Integer.class);
            }
            if (propType == long.class)
            {
                return(Long.class);
            }
            if (propType == float.class)
            {
                return(Float.class);
            }
            if (propType == double.class)
            {
                return(Double.class);
            }
        }
        else
        if (Number.class.isAssignableFrom(propType))
        {
            return propType;
        }

        return String.class;
    }
}
