/**
 * Copyright (c) 2002 Sonic Software Corporation. All Rights Reserved.
 *
 * This software is the confidential and proprietary information of Sonic
 * Software Corpoation. (Confidential Information).  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sonic.
 *
 * SONIC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SONIC SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 *
 * CopyrightVersion 1.0
 */
package com.sonicsw.ma.gui.table;

import java.awt.Component;
import java.util.HashMap;
import java.util.Map;

import javax.swing.Icon;
import javax.swing.JTable;
import javax.swing.SwingConstants;

import com.sonicsw.ma.gui.util.ExtendedJTable;
import com.sonicsw.ma.gui.util.ImageOverlayIcon;
import com.sonicsw.ma.gui.util.ResourceManager;
import com.sonicsw.ma.gui.util.Utils;
import com.sonicsw.ma.plugin.IPlugin;
import com.sonicsw.ma.plugin.IPluginFactory;
import com.sonicsw.mx.config.IConfigBean;
import com.sonicsw.mx.config.IdentityOnlyConfigBean;

public class ConfigBeanTableCellRenderer extends ExtendedJTable.ExtendedTableCellRenderer
{
    protected IPlugin m_plugin;

    protected static Map typeVsOverLayIconMap = new HashMap();

    public ConfigBeanTableCellRenderer(IPlugin plugin)
    {
        setHorizontalAlignment();

        m_plugin = plugin;
    }

    private void setHorizontalAlignment() {
        setHorizontalAlignment(SwingConstants.LEFT);
    }
    
    @Override
    public Component getTableCellRendererComponent(JTable  table,
                                                   Object  value,
                                                   boolean isSelected,
                                                   boolean hasFocus,
                                                   int     row,
                                                   int     column)
    {
        Component result = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);

        String type = null;
        String version = null;

        if (value instanceof IConfigBean)
        {
            final IConfigBean bean = (IConfigBean) value;
            type    = bean.getConfigType().getName();
            version = bean.getConfigType().getVersion();
        }

        // The plugin is the parent plugin for the content pane and renderer...
        // it cannot be used to obtain the classpath. e.g. a container (mf) will
        // not find a broker (mq) resource bundle...so we load the root factory
        // for this bean type.
        //
        IPluginFactory pf = m_plugin.getPluginContext().getConfigContext().getPluginFactory(type, version, null);

        if (value instanceof IdentityOnlyConfigBean) {
            if (IdentityOnlyConfigBean.isUnidentifiable((IConfigBean) value) || pf==null) {
                setIcon(getNoPermsIconFor(getClass(), null));
            } else {
                if (pf != null) {
                    setIcon(getNoPermsIconFor(pf.getClass(), type));
                }
            }
        } else {
            if (pf != null) {
                setIcon(ResourceManager.getTypeIcon(pf.getClass(), type));
            } else {
                setIcon(ResourceManager.getTypeIcon(getClass(), null));  // Unknown icon
            }

        }

        final String text = getCaptionText(value);

        setText(text);
        setToolTipText(result, table, text, column);

        return result;
    }

    protected static String getCaptionText(Object value) {
        String ret = "";

        if (value instanceof IConfigBean) {
            final String configBeanName = Utils.getConfigBeanIdentifierName((IConfigBean) value);
            ret = DSToViewPathStringTableColumn.formatPath(configBeanName);
        }

        return ret;
    }

    protected static Icon getNoPermsIconFor(Class clazz, String type){
        String typeKey = type==null?"unknown.Type":type;
        Icon icon = (Icon) typeVsOverLayIconMap.get(typeKey);
        if(icon!=null)
        {
            return icon;
        }
        Icon noPerms = ResourceManager.getIcon(clazz,"lock3"); // lock
        Icon typeIcon = ResourceManager.getTypeIcon(clazz, type);  // type
        icon = new ImageOverlayIcon(typeIcon,noPerms);
        typeVsOverLayIconMap.put(typeKey,icon);
        return icon;
    }

}
