/**
 * Copyright (c) 2002 Sonic Software Corporation. All Rights Reserved.
 *
 * This software is the confidential and proprietary information of Sonic
 * Software Corpoation. (Confidential Information).  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sonic.
 *
 * SONIC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SONIC SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 *
 * CopyrightVersion 1.0
 */
package com.sonicsw.ma.gui.table;

import com.sonicsw.ma.plugin.ConfigBeanModel;
import com.sonicsw.mx.config.IAttributeMap;
import com.sonicsw.mx.config.IConfigBean;
import com.sonicsw.mx.config.IConfigPath;
import com.sonicsw.mx.config.IdentityOnlyConfigBean;

public class ConfigBeanTableColumn extends RowTableColumn
{
    protected IConfigPath m_configPath;


    public ConfigBeanTableColumn(int    modelIndex,
                                 String title,
                                 int    width)
    {
        this(modelIndex, ConfigBeanModel.NAME, title, width);
    }

    public ConfigBeanTableColumn(int         modelIndex,
                                 IConfigPath path,
                                 String      title,
                                 int         width)
    {
        this(modelIndex, path, title, String.class, width);
    }

    public ConfigBeanTableColumn(int         modelIndex,
                                 IConfigPath path,
                                 String      title,
                                 Class       type,
                                 int         width)
    {
        super(modelIndex, title, width);

        setColumnClass(type);

        m_configPath = path;
    }

    @Override
    public Object getColumnValue(Object rowModel)
    {
        Object          value   = null;
        ConfigBeanModel cbModel = (ConfigBeanModel)rowModel;

        if(cbModel != null)
        {
            if (m_configPath == null)
            {
                IAttributeMap data = cbModel.getData();

                if ((getColumnClass() == IConfigBean.class) &&
                    (data instanceof IConfigBean))
                {
                    value = (IConfigBean)data;
                }
                else
                {
                    value = cbModel;
                }
            }
            else if (m_configPath.equals(ConfigBeanModel.NAME))
            {
                value = cbModel.getViewName();
            }
            else
            {
                IAttributeMap data = cbModel.getData();
                if(data != null && !(data instanceof IdentityOnlyConfigBean))
                {
                    value = data.getAttribute(m_configPath);
                }
            }
        }
        return value;
    }
}
