/**
 * Copyright (c) 2002 Sonic Software Corporation. All Rights Reserved.
 *
 * This software is the confidential and proprietary information of Sonic
 * Software Corpoation. (Confidential Information).  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sonic.
 *
 * SONIC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SONIC SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 *
 * CopyrightVersion 1.0
 */
package com.sonicsw.ma.gui.table;

import java.util.Iterator;

import com.sonicsw.ma.plugin.ConfigBeanModel;
import com.sonicsw.ma.plugin.IPlugin;
import com.sonicsw.mx.config.IAttributeDescription;
import com.sonicsw.mx.config.IAttributeList;
import com.sonicsw.mx.config.IAttributeMap;
import com.sonicsw.mx.config.IdentityOnlyConfigBean;

public abstract class ConfigBeanTableContentPane extends AbstractTableContentPane
{
    public ConfigBeanTableContentPane(IPlugin plugin)
    {
        super(plugin);
    }

    @Override
    public void setTableData(IPlugin plugin)
    {
        ConfigBeanModel  beanModel = (ConfigBeanModel)getRowModel(plugin);
        IModelTableModel tableModel = (IModelTableModel)m_table.getModel();

        tableModel.clear();

        if (beanModel != null)
        {
            if (beanModel.getData() instanceof IAttributeMap)
            {
                IAttributeMap beanMap = beanModel.getData();
                Iterator      i       = beanMap.keySet().iterator();

                while (i.hasNext())
                {
                    String        name = (String)i.next();
                    IAttributeMap map  = (IAttributeMap)beanMap.getAttribute(name);
                    ConfigBeanModel rowModel = new ConfigBeanModel(map, beanModel.getType(), name);

                    if (canAddRowToModel(rowModel))
                    {
                        tableModel.addRow(rowModel);
                    }
                }
            }
            else
            if (beanModel.getDataList() instanceof IAttributeList)
            {
                IAttributeList beanList = beanModel.getDataList();
                Iterator       i        = beanList.iterator();
                int            count    = 0;

                while (i.hasNext())
                {
                    Object listItem = i.next();

                    if (listItem instanceof IAttributeMap)
                    {
                        IAttributeMap            mapData = (IAttributeMap)listItem;
                        IAttributeDescription mapType = null;
                        if(!(mapData instanceof IdentityOnlyConfigBean)){
                            mapType = mapData.getAttributeDescription();
                        }
                        ConfigBeanModel          rowModel = new ConfigBeanModel(mapData, mapType, Integer.toString(count++));

                        if (canAddRowToModel(rowModel))
                        {
                            tableModel.addRow(rowModel);
                        }
                    }
                    else
                    if (listItem instanceof IAttributeList)
                    {
                        IAttributeList listData = (IAttributeList)listItem;
                        IAttributeDescription listType = listData.getAttributeDescription();
                        ConfigBeanModel rowModel = new ConfigBeanModel(listData, listType, Integer.toString(count++));

                        if (canAddRowToModel(rowModel))
                        {
                            tableModel.addRow(rowModel);
                        }
                    }
                }
            }
        }
    }

    /**
     * This method gets called before each row model is added into the table
     * model.
     *
     * Override this to selectively add rows.
     *
     * @param rowModel   the row about to be added to the table model.
     * @return           true if the row should be added otherwise false.
     */
    protected boolean canAddRowToModel(ConfigBeanModel rowModel)
    {
        return true;
    }

    protected abstract ConfigBeanModel getRowModel(IPlugin plugin);

}
