/**
 * Copyright (c) 2002 Sonic Software Corporation. All Rights Reserved.
 *
 * This software is the confidential and proprietary information of Sonic
 * Software Corpoation. (Confidential Information).  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sonic.
 *
 * SONIC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SONIC SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 *
 * CopyrightVersion 1.0
 */
package com.sonicsw.ma.gui.table;

import java.awt.Component;
import java.awt.Font;

import javax.swing.JTable;
import javax.swing.SwingConstants;

import com.sonicsw.ma.gui.util.ExtendedJTable;
import com.sonicsw.ma.plugin.ConfigBeanModel;
import com.sonicsw.mx.config.ConfigServerUtility;
import com.sonicsw.mx.config.IConfigElement;
import com.sonicsw.mx.config.IConfigPath;
import com.sonicsw.mx.config.IConfigPrototype;

public class ConfigElementTableCellRenderer extends ExtendedJTable.ExtendedTableCellRenderer
{
    protected Font        m_plainFont;
    protected Font        m_italicFont;
    protected String      m_typeTip;
    protected IConfigPath m_namePath;

    public ConfigElementTableCellRenderer(IConfigPath name)
    {
        this(null, name);
    }

    public ConfigElementTableCellRenderer(String typeTip, IConfigPath name)
    {
        setHorizontalAlignment();

        m_typeTip = typeTip;
        m_namePath = name;
    }

    private void setHorizontalAlignment() {
        setHorizontalAlignment(SwingConstants.LEFT);
    }
    
    @Override
    public Component getTableCellRendererComponent(JTable  table,
                                                   Object  value,
                                                   boolean isSelected,
                                                   boolean hasFocus,
                                                   int     row,
                                                   int     column)
    {
        Component result = super.getTableCellRendererComponent(table,value,isSelected,hasFocus,row,column);

        if (table.getModel() instanceof ModelListTableModel)
        {
            Object rowModel = ((ModelListTableModel)table.getModel()).getRowModel(row);

            if (rowModel instanceof ConfigBeanModel)
            {
                rowModel = ((ConfigBeanModel)rowModel).getData();
            }

            if (rowModel instanceof IConfigElement)
            {
                IConfigElement ce       = (IConfigElement)rowModel;
                String         viewName = (m_namePath != null) ? (String)ce.getAttribute(m_namePath) : null;
                
                if (ce instanceof IConfigPrototype)
                {
                    if (m_italicFont == null)
                    {
                        m_italicFont = result.getFont().deriveFont(Font.ITALIC | Font.BOLD);
                    }

                    result.setFont(m_italicFont);
                }
                else
                {
                    if (m_plainFont == null)
                    {
                        m_plainFont = result.getFont().deriveFont(Font.PLAIN);
                    }

                    result.setFont(m_plainFont);
                }

                setToolTipText(buildToolTipText(ce, viewName));
            }
            else
            {
                setToolTipText(null);
            }
        }
        else
        {
            setToolTipText(null);
        }

        setText((String)value);

        return this;
    }

    private String buildToolTipText(IConfigElement ce, String viewName)
    {
        StringBuffer buffer = new StringBuffer();
        buffer.append("<html>");

        if (m_typeTip != null)
        {
            buffer.append("Type: " + m_typeTip).append("<br>");
        }

        if (viewName != null)
        {
            buffer.append("Name: " + viewName).append("<br>");
        }
        
        String path = ce.getName();
        
        if (path.endsWith(ConfigServerUtility.DEFAULT_SUFFIX))
        {
            path = path.substring(0, path.lastIndexOf('/'));
        }
        
        buffer.append("Configuration: " + path);

        if (ce instanceof IConfigPrototype)
        {
            buffer.append("<br>").append("Template: yes");
        }

        if (ce.isPrototypeInstance())
        {
            buffer.append("<br>");
            buffer.append("Linked to template: ");
            buffer.append(ce.getPrototype().getName());
        }

        buffer.append("</html>");

        return buffer.toString();
    }
}
