/**
 * Copyright (c) 2002 Sonic Software Corporation. All Rights Reserved.
 *
 * This software is the confidential and proprietary information of Sonic
 * Software Corpoation. (Confidential Information).  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sonic.
 *
 * SONIC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SONIC SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 *
 * CopyrightVersion 1.0
 */
package com.sonicsw.ma.gui.table;

import com.sonicsw.ma.plugin.ConfigBeanModel;
import com.sonicsw.ma.plugin.IConfigPlugin;
import com.sonicsw.mx.config.IConfigPath;

public class ConfigPluginTableColumn extends RowTableColumn
{
    protected IConfigPath m_configPath;


    public ConfigPluginTableColumn(int    modelIndex,
                                   int    width,
                                   String title)
    {
        this(modelIndex, width, title, ConfigBeanModel.NAME);
    }

    public ConfigPluginTableColumn(int         modelIndex,
                                   int         width,
                                   String      title,
                                   IConfigPath path)
    {
        this(modelIndex, width, title, path, String.class);
    }

    public ConfigPluginTableColumn(int         modelIndex,
                                   int         width,
                                   String      title,
                                   IConfigPath path,
                                   Class       type)
    {
        super(modelIndex, title, width);

        setColumnClass(type);

        m_configPath = path;
    }

    @Override
    public Object getColumnValue(Object rowModel)
    {
        Object          value   = null;
        IConfigPlugin   plugin  = (IConfigPlugin)rowModel;
        ConfigBeanModel cbModel = (ConfigBeanModel)plugin.getModel();

        if (cbModel != null)
        {
            if (m_configPath.equals(ConfigBeanModel.NAME))
            {
                value = cbModel.getViewName();
            }
            else if (cbModel.getData() != null)
            {
                value = cbModel.getData().getAttribute(m_configPath);
            }

            if ((value == null) && (getColumnClass() == String.class))
            {
                return "-";
            }
        }

        return value;
    }
}
